/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.io.Serializable;
import java.util.HashMap;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.instruct.Bindery;
import net.sf.saxon.instruct.CallableFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trace.InstructionInfo;
import net.sf.saxon.trace.TraceListener;
import net.sf.saxon.value.Value;
import net.sf.saxon.xpath.XPathException;

public final class UserFunction
implements CallableFunction,
Serializable,
InstructionInfo {
    private Expression body;
    private String functionName;
    private boolean memoFunction = false;
    private int lineNumber;

    public UserFunction(Expression expression) {
        this.body = expression;
    }

    public void setLineNumber(int n) {
        this.lineNumber = n;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getSystemId() {
        return null;
    }

    public String getInstructionName() {
        return "function";
    }

    public String getProperty(String string) {
        if (string.equals("name")) {
            return this.functionName;
        }
        return null;
    }

    public void setMemoFunction(boolean bl) {
        this.memoFunction = bl;
    }

    public void setFunctionName(String string) {
        this.functionName = string;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public Value call(Value[] valueArray, Controller controller) throws TransformerException {
        Value value;
        Object object;
        if (this.memoFunction && (object = this.getCachedValue(controller, valueArray)) != null) {
            return object;
        }
        if (controller.isTracing()) {
            object = controller.getTraceListener();
            object.enter(this);
        }
        object = controller.getBindery();
        ((Bindery)object).openStackFrame(valueArray);
        try {
            value = ExpressionTool.eagerEvaluate(this.body, controller.newXPathContext());
        }
        catch (XPathException xPathException) {
            System.err.println("Dynamic error in function " + this.functionName);
            throw xPathException;
        }
        ((Bindery)object).closeStackFrame();
        if (controller.isTracing()) {
            TraceListener traceListener = controller.getTraceListener();
            traceListener.leave(this);
        }
        if (this.memoFunction) {
            this.putCachedValue(controller, valueArray, value);
        }
        return value;
    }

    private Value getCachedValue(Controller controller, Value[] valueArray) {
        try {
            HashMap hashMap = (HashMap)controller.getUserData(this, "memo-function-cache");
            if (hashMap == null) {
                return null;
            }
            String string = UserFunction.getCombinedKey(valueArray);
            return (Value)hashMap.get(string);
        }
        catch (XPathException xPathException) {
            return null;
        }
    }

    private void putCachedValue(Controller controller, Value[] valueArray, Value value) {
        try {
            HashMap<String, Value> hashMap = (HashMap<String, Value>)controller.getUserData(this, "memo-function-cache");
            if (hashMap == null) {
                hashMap = new HashMap<String, Value>();
                controller.setUserData(this, "memo-function-cache", hashMap);
            }
            String string = UserFunction.getCombinedKey(valueArray);
            hashMap.put(string, value);
        }
        catch (XPathException xPathException) {}
    }

    private static String getCombinedKey(Value[] valueArray) throws XPathException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < valueArray.length) {
            Value value = valueArray[n];
            SequenceIterator sequenceIterator = value.iterate(null);
            while (sequenceIterator.hasNext()) {
                Item item = sequenceIterator.next();
                if (item instanceof NodeInfo) {
                    NodeInfo nodeInfo = (NodeInfo)item;
                    stringBuffer.append(nodeInfo.generateId());
                } else {
                    stringBuffer.append("" + item.getItemType());
                    stringBuffer.append('/');
                    stringBuffer.append(item.getStringValue());
                }
                stringBuffer.append('\u0001');
            }
            stringBuffer.append('\u0002');
            ++n;
        }
        return stringBuffer.toString();
    }
}

