/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.util.List;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Controller;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.ExprInstruction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Orphan;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.xpath.XPathException;

public abstract class SimpleNodeConstructor
extends ExprInstruction {
    private String stringValue = null;
    protected Expression valueExpression = null;

    public void setContent(String string) {
        this.stringValue = string;
    }

    public final void setValueExpression(Expression expression) {
        this.valueExpression = expression;
    }

    public abstract void typeCheck(StaticContext var1) throws XPathException;

    public Expression analyze(StaticContext staticContext) throws XPathException {
        this.typeCheck(staticContext);
        if (this.valueExpression != null) {
            this.valueExpression = this.valueExpression.analyze(staticContext);
            RoleLocator roleLocator = new RoleLocator(4, this.getInstructionName() + "/content", 0);
            this.valueExpression = TypeChecker.staticTypeCheck(this.valueExpression, SequenceType.SINGLE_STRING, false, roleLocator);
        } else if (this.children != null) {
            int n = 0;
            while (n < this.children.length) {
                if (!(this.children[n] instanceof ExprInstruction)) {
                    throw new IllegalStateException("Children of an ExprInstruction must themselves be ExprInstructions");
                }
                this.children[n] = (ExprInstruction)((ExprInstruction)this.children[n]).analyze(staticContext);
                ++n;
            }
        }
        return this;
    }

    public void getXPathExpressions(List list) {
        if (this.stringValue != null) {
            return;
        }
        if (this.valueExpression != null) {
            list.add(this.valueExpression);
            return;
        }
    }

    public CharSequence expandChildren(XPathContext xPathContext) throws TransformerException {
        if (this.stringValue != null) {
            return this.stringValue;
        }
        if (this.valueExpression != null) {
            return this.valueExpression.evaluateAsString(xPathContext);
        }
        Controller controller = xPathContext.getController();
        SequenceReceiver sequenceReceiver = controller.getReceiver();
        StringBuffer stringBuffer = new StringBuffer();
        controller.changeToTextOutputDestination(stringBuffer);
        this.processChildren(xPathContext);
        controller.resetOutputDestination(sequenceReceiver);
        return stringBuffer;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        String string = this.stringValue;
        if (string == null) {
            string = this.valueExpression == null ? "" : this.valueExpression.evaluateAsString(xPathContext);
        }
        Orphan orphan = new Orphan(xPathContext.getController().getNamePool());
        orphan.setNodeKind((short)this.getItemType());
        orphan.setStringValue(string);
        try {
            orphan.setNameCode(this.evaluateNameCode(xPathContext));
        }
        catch (XPathException xPathException) {
            throw xPathException;
        }
        catch (TransformerException transformerException) {
            throw new XPathException.Dynamic(transformerException);
        }
        return orphan;
    }

    protected int evaluateNameCode(XPathContext xPathContext) throws XPathException, TransformerException {
        return -1;
    }

    public void display(int n) {
        if (this.stringValue != null) {
            System.err.println(ExpressionTool.indent(n) + '\"' + this.stringValue + '\"');
        } else if (this.valueExpression != null) {
            this.valueExpression.display(n);
        } else if (this.children.length == 0) {
            System.err.println(ExpressionTool.indent(n) + "empty content");
        } else {
            int n2 = 0;
            while (n2 < this.children.length) {
                if (this.children[n2] instanceof Expression) {
                    ((Expression)((Object)this.children[n2])).display(n + 1);
                } else {
                    System.err.println(ExpressionTool.indent(n + 1) + this.children[n2].getInstructionName());
                }
                ++n2;
            }
        }
    }
}

