/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.value.StringValue;

public class RegexIterator
implements SequenceIterator {
    private String theString;
    private Pattern pattern;
    private Matcher matcher;
    private String current;
    private String next;
    private int position = 0;
    private int prevEnd = 0;
    private boolean currentMatches = false;
    private boolean nextMatches = false;
    private boolean hasNext = false;
    private String[] currentGroups;
    private String[] nextGroups;

    public RegexIterator(String string, Pattern pattern) {
        this.theString = string;
        this.pattern = pattern;
        this.matcher = pattern.matcher(string);
        this.nextMatches = true;
        this.prevEnd = 0;
        this.advance();
    }

    private void advance() {
        if (this.nextMatches) {
            if (this.matcher.find()) {
                this.hasNext = true;
                int n = this.matcher.start();
                int n2 = this.matcher.end();
                if (this.prevEnd == n) {
                    this.nextMatches = true;
                    this.next = this.theString.substring(n, n2);
                    int n3 = this.matcher.groupCount();
                    this.nextGroups = new String[n3 + 1];
                    int n4 = 0;
                    while (n4 <= n3) {
                        this.nextGroups[n4] = this.matcher.group(n4);
                        ++n4;
                    }
                    this.prevEnd = n2;
                } else {
                    this.nextMatches = false;
                    this.next = this.theString.substring(this.prevEnd, n);
                }
            } else {
                if (this.prevEnd < this.theString.length()) {
                    this.nextMatches = false;
                    this.next = this.theString.substring(this.prevEnd);
                    this.hasNext = true;
                } else {
                    this.hasNext = false;
                }
                this.prevEnd = -1;
            }
        } else if (this.prevEnd >= 0) {
            this.nextMatches = true;
            int n = this.matcher.start();
            int n5 = this.matcher.end();
            this.next = this.theString.substring(n, n5);
            int n6 = this.matcher.groupCount();
            this.nextGroups = new String[n6 + 1];
            int n7 = 0;
            while (n7 <= n6) {
                this.nextGroups[n7] = this.matcher.group(n7);
                ++n7;
            }
            this.prevEnd = n5;
        } else {
            this.hasNext = false;
        }
    }

    public boolean hasNext() {
        return this.hasNext;
    }

    public Item next() {
        this.current = this.next;
        this.currentMatches = this.nextMatches;
        this.currentGroups = this.nextGroups;
        this.advance();
        ++this.position;
        return new StringValue(this.current);
    }

    public Item current() {
        return new StringValue(this.current);
    }

    public int position() {
        return this.position;
    }

    public SequenceIterator getAnother() {
        return new RegexIterator(this.theString, this.pattern);
    }

    public boolean isMatching() {
        return this.currentMatches;
    }

    public String getRegexGroup(int n) {
        if (!this.currentMatches) {
            return null;
        }
        if (n < 1) {
            return "";
        }
        if (n >= this.currentGroups.length) {
            return "";
        }
        String string = this.currentGroups[n];
        if (string == null) {
            return "";
        }
        return string;
    }
}

