/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Controller;
import net.sf.saxon.Loader;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.number.NumberFormatter;
import net.sf.saxon.number.Numberer;
import net.sf.saxon.number.Numberer_en;
import net.sf.saxon.om.Navigator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Type;
import net.sf.saxon.xpath.XPathException;

public class Number
extends Instruction {
    private static final int SINGLE = 0;
    private static final int MULTI = 1;
    private static final int ANY = 2;
    private static final int SIMPLE = 3;
    private int level;
    private Pattern count = null;
    private Pattern from = null;
    private Expression select = null;
    private Expression value = null;
    private Expression format = null;
    private Expression groupSize = null;
    private Expression groupSeparator = null;
    private Expression letterValue = null;
    private Expression lang = null;
    private NumberFormatter formatter = null;
    private Numberer numberer = null;
    private boolean hasVariablesInPatterns;
    private static Numberer defaultNumberer = new Numberer_en();

    public Number(Expression expression, int n, Pattern pattern, Pattern pattern2, Expression expression2, Expression expression3, Expression expression4, Expression expression5, Expression expression6, Expression expression7, NumberFormatter numberFormatter, Numberer numberer, boolean bl) {
        this.select = expression;
        this.level = n;
        this.count = pattern;
        this.from = pattern2;
        this.value = expression2;
        this.format = expression3;
        this.groupSize = expression4;
        this.groupSeparator = expression5;
        this.letterValue = expression6;
        this.lang = expression7;
        this.formatter = numberFormatter;
        this.numberer = numberer;
        this.hasVariablesInPatterns = bl;
        if (this.value != null && !Type.isSubType(this.value.getItemType(), 90)) {
            this.value = new Atomizer(this.value);
        }
    }

    public String getInstructionName() {
        return "xsl:number";
    }

    public SequenceType getResultType() {
        return new SequenceType(3, 88, 512);
    }

    public TailCall processLeavingTail(XPathContext xPathContext) throws TransformerException {
        NumberFormatter numberFormatter;
        Object object;
        Object object2;
        Object object3;
        Controller controller = xPathContext.getController();
        SequenceReceiver sequenceReceiver = controller.getReceiver();
        long l = -1L;
        List<Long> list = null;
        if (this.value != null) {
            object3 = this.value.iterate(xPathContext);
            list = new ArrayList();
            while (object3.hasNext()) {
                object2 = (AtomicValue)object3.next();
                try {
                    object = object2 instanceof NumericValue ? (NumericValue)object2 : (NumericValue)((AtomicValue)object2).convert(105);
                    object = ((NumericValue)object).round();
                    long l2 = ((IntegerValue)((AtomicValue)object).convert(200)).asLong();
                    list.add(new Long(l2));
                    if (l2 >= 1L) continue;
                    throw new XPathException.Dynamic("The numbers to be formatted must be positive");
                }
                catch (XPathException xPathException) {
                    this.recoverableError(xPathException.getMessage(), controller);
                }
            }
        } else {
            if (this.select != null) {
                object3 = (NodeInfo)this.select.evaluateItem(xPathContext);
            } else {
                object2 = controller.getCurrentItem();
                if (!(object2 instanceof NodeInfo)) {
                    this.recoverableError("context item for xsl:number must be a node", controller);
                    return null;
                }
                object3 = (NodeInfo)object2;
            }
            if (this.level == 3) {
                l = Navigator.getNumberSimple((NodeInfo)object3, controller);
            } else if (this.level == 0) {
                l = Navigator.getNumberSingle((NodeInfo)object3, this.count, this.from, controller);
                if (l == 0L) {
                    list = new ArrayList();
                }
            } else if (this.level == 2) {
                l = Navigator.getNumberAny(this, (NodeInfo)object3, this.count, this.from, controller, this.hasVariablesInPatterns);
                if (l == 0L) {
                    list = new ArrayList();
                }
            } else if (this.level == 1) {
                list = Navigator.getNumberMulti((NodeInfo)object3, this.count, this.from, controller);
            }
        }
        int n = 0;
        object2 = "";
        if (this.groupSize != null) {
            String string = this.groupSize.evaluateAsString(xPathContext);
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                throw this.styleError("group-size must be numeric", controller);
            }
        }
        if (this.groupSeparator != null) {
            object2 = this.groupSeparator.evaluateAsString(xPathContext);
        }
        if (list == null && this.format == null && n == 0 && this.lang == null) {
            sequenceReceiver.characters("" + l, 0);
            return null;
        }
        if (this.numberer == null) {
            this.numberer = Number.makeNumberer(this.lang.evaluateAsString(xPathContext));
        }
        if (this.letterValue == null) {
            object = "";
        } else {
            object = this.letterValue.evaluateAsString(xPathContext);
            if (!((String)object).equals("alphabetic") && !((String)object).equals("traditional")) {
                throw this.styleError("letter-value must be \"traditional\" or \"alphabetic\"", controller);
            }
        }
        if (list == null) {
            list = new ArrayList();
            list.add(new Long(l));
        }
        if (this.formatter == null) {
            numberFormatter = new NumberFormatter();
            numberFormatter.prepare(this.format.evaluateAsString(xPathContext));
        } else {
            numberFormatter = this.formatter;
        }
        String string = numberFormatter.format(list, n, (String)object2, (String)object, this.numberer);
        sequenceReceiver.characters(string, 0);
        return null;
    }

    protected static Numberer makeNumberer(String string) {
        Numberer numberer;
        if (string.equals("en")) {
            numberer = defaultNumberer;
        } else {
            String string2 = "net.sf.saxon.number.Numberer_";
            int n = 0;
            while (n < string.length()) {
                if (Character.isLetter(string.charAt(n))) {
                    string2 = string2 + string.charAt(n);
                }
                ++n;
            }
            try {
                numberer = (Numberer)Loader.getInstance(string2);
            }
            catch (Exception exception) {
                numberer = defaultNumberer;
            }
        }
        return numberer;
    }
}

