/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.util.List;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.SimpleNodeConstructor;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.om.XMLChar;
import net.sf.saxon.value.SequenceType;

public class Namespace
extends SimpleNodeConstructor {
    private Expression name;

    public Namespace(Expression expression) {
        this.name = expression;
    }

    public String getInstructionName() {
        return "xsl:namespace";
    }

    public SequenceType getResultType() {
        return new SequenceType(13, 88, 512);
    }

    public void promoteInst(PromotionOffer promotionOffer) {
        throw new UnsupportedOperationException("Namespace instruction cannot be used as an expression");
    }

    public void typeCheck(StaticContext staticContext) {
    }

    public void getXPathExpressions(List list) {
        list.add(this.name);
        super.getXPathExpressions(list);
    }

    public TailCall processLeavingTail(XPathContext xPathContext) throws TransformerException {
        Controller controller = xPathContext.getController();
        String string = this.name.evaluateAsString(xPathContext);
        if (!string.equals("") && !XMLChar.isValidNCName(string)) {
            this.recoverableError("Namespace prefix is invalid: " + string, controller);
            return null;
        }
        String string2 = this.expandChildren(xPathContext).toString();
        if (string2.equals("")) {
            this.recoverableError("Namespace URI is an empty string", controller);
            return null;
        }
        int n = controller.getNamePool().allocateNamespaceCode(string, string2);
        controller.getReceiver().namespace(n, 32);
        return null;
    }
}

