/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import javax.xml.transform.TransformerException;
import net.sf.saxon.Controller;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.AttributeSet;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;

public class LiteralElement
extends Instruction {
    private int resultNameCode;
    private int[] attributeNames;
    private Expression[] attributeValues;
    private boolean[] attributeChecked;
    private AttributeSet[] attributeSets;
    private int[] namespaceCodes;
    private int annotation;

    public LiteralElement(int n, int[] nArray, Expression[] expressionArray, boolean[] blArray, AttributeSet[] attributeSetArray, int[] nArray2, int n2) {
        this.resultNameCode = n;
        this.attributeNames = nArray;
        this.attributeValues = expressionArray;
        this.attributeChecked = blArray;
        this.attributeSets = attributeSetArray;
        this.namespaceCodes = nArray2;
        this.annotation = n2;
    }

    public String getInstructionName() {
        return "***LRE***";
    }

    public String getInstructionName(Controller controller) {
        return controller.getNamePool().getDisplayName(this.resultNameCode);
    }

    public SequenceType getResultType() {
        return new SequenceType(1, 88, 512);
    }

    public TailCall processLeavingTail(XPathContext xPathContext) throws TransformerException {
        Controller controller = xPathContext.getController();
        SequenceReceiver sequenceReceiver = controller.getReceiver();
        sequenceReceiver.startElement(this.resultNameCode, this.annotation, 64);
        int n = 0;
        while (n < this.namespaceCodes.length) {
            sequenceReceiver.namespace(this.namespaceCodes[n], 0);
            ++n;
        }
        if (this.attributeSets != null) {
            AttributeSet.expand(this.attributeSets, xPathContext);
        }
        if (this.attributeNames != null) {
            int n2 = this.attributeNames.length;
            int n3 = 0;
            while (n3 < n2) {
                int n4 = this.attributeNames[n3];
                Expression expression = this.attributeValues[n3];
                int n5 = 64;
                if (expression instanceof StringValue) {
                    if (this.attributeChecked[n3]) {
                        n5 |= 4;
                    }
                    sequenceReceiver.attribute(n4, 0, ((StringValue)expression).getStringValue(), n5);
                } else {
                    String string = expression.evaluateAsString(xPathContext);
                    sequenceReceiver.attribute(n4, 0, string, n5);
                }
                ++n3;
            }
        }
        this.processChildren(xPathContext);
        sequenceReceiver.endElement();
        return null;
    }
}

