/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.io.Serializable;
import javax.xml.transform.TransformerException;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.InstructionDetails;
import net.sf.saxon.instruct.LiteralElement;
import net.sf.saxon.instruct.SkipInstructionException;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.instruct.TerminationException;
import net.sf.saxon.trace.TraceListener;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.xpath.XPathException;

public abstract class Instruction
implements Serializable {
    Instruction[] children;
    private int sourceLocation;

    public void setChildren(Instruction[] instructionArray) {
        this.children = instructionArray;
    }

    public Instruction[] getChildren() {
        return this.children;
    }

    public void setSourceLocation(int n, int n2) {
        this.sourceLocation = n << 20 | n2 & 0x7FFFF;
    }

    public String getSystemId(Executable executable) {
        int n = this.sourceLocation >> 20 & 0x3FF;
        return executable.getSystemId(n);
    }

    public int getLineNumber() {
        return this.sourceLocation & 0x7FFFF;
    }

    public InstructionDetails getInstructionDetails(Controller controller) {
        InstructionDetails instructionDetails = new InstructionDetails();
        String string = this instanceof LiteralElement ? ((LiteralElement)this).getInstructionName(controller) : this.getInstructionName();
        instructionDetails.setInstructionName(string);
        instructionDetails.setSystemId(this.getSystemId(controller.getExecutable()));
        instructionDetails.setLineNumber(this.getLineNumber());
        return instructionDetails;
    }

    public abstract String getInstructionName();

    public SequenceType getResultType() {
        return SequenceType.ANY_SEQUENCE;
    }

    public abstract TailCall processLeavingTail(XPathContext var1) throws TransformerException;

    public void process(XPathContext xPathContext) throws TransformerException {
        TailCall tailCall = this.processLeavingTail(xPathContext);
        while (tailCall != null) {
            tailCall = tailCall.processLeavingTail(xPathContext);
        }
    }

    protected void processChildren(XPathContext xPathContext) throws TransformerException {
        if (this.children == null) {
            return;
        }
        Controller controller = xPathContext.getController();
        if (controller.isTracing()) {
            TraceListener traceListener = controller.getTraceListener();
            int n = 0;
            while (n < this.children.length) {
                try {
                    InstructionDetails instructionDetails = this.children[n].getInstructionDetails(controller);
                    traceListener.enter(instructionDetails);
                    this.children[n].process(xPathContext);
                    traceListener.leave(instructionDetails);
                }
                catch (TransformerException transformerException) {
                    if (transformerException instanceof SkipInstructionException) {
                        this.children[n].recoverableError(transformerException.getMessage(), controller);
                    }
                    throw this.children[n].styleError(transformerException, controller);
                }
                ++n;
            }
        } else {
            int n = 0;
            while (n < this.children.length) {
                try {
                    this.children[n].process(xPathContext);
                }
                catch (TransformerException transformerException) {
                    if (transformerException instanceof SkipInstructionException) {
                        this.children[n].recoverableError(transformerException.getMessage(), controller);
                    }
                    throw this.children[n].styleError(transformerException, controller);
                }
                ++n;
            }
        }
    }

    protected TailCall processChildrenLeavingTail(XPathContext xPathContext) throws TransformerException {
        if (this.children == null) {
            return null;
        }
        Controller controller = xPathContext.getController();
        TailCall tailCall = null;
        if (controller.isTracing()) {
            TraceListener traceListener = controller.getTraceListener();
            int n = 0;
            while (n < this.children.length) {
                try {
                    InstructionDetails instructionDetails = this.children[n].getInstructionDetails(controller);
                    traceListener.enter(instructionDetails);
                    tailCall = this.children[n].processLeavingTail(xPathContext);
                    traceListener.leave(instructionDetails);
                }
                catch (TransformerException transformerException) {
                    if (transformerException instanceof SkipInstructionException) {
                        this.children[n].recoverableError(transformerException.getMessage(), controller);
                    }
                    throw this.children[n].styleError(transformerException, controller);
                }
                ++n;
            }
        } else {
            int n = 0;
            while (n < this.children.length) {
                try {
                    tailCall = this.children[n].processLeavingTail(xPathContext);
                }
                catch (TransformerException transformerException) {
                    if (transformerException instanceof SkipInstructionException) {
                        this.children[n].recoverableError(transformerException.getMessage(), controller);
                    }
                    throw this.children[n].styleError(transformerException, controller);
                }
                ++n;
            }
        }
        return tailCall;
    }

    protected TransformerException styleError(TransformerException transformerException, Controller controller) {
        if (transformerException instanceof TerminationException) {
            return transformerException;
        }
        if (transformerException.getException() instanceof TransformerException) {
            return this.styleError((TransformerException)transformerException.getException(), controller);
        }
        if (transformerException.getLocator() == null) {
            try {
                InstructionDetails instructionDetails = this.getInstructionDetails(controller);
                return new TransformerException(transformerException.getMessage(), instructionDetails, transformerException.getException());
            }
            catch (Exception exception) {
                return transformerException;
            }
        }
        if (transformerException instanceof XPathException) {
            if (controller.getConfiguration().getHostLanguage() == 11) {
                return transformerException;
            }
            try {
                InstructionDetails instructionDetails = this.getInstructionDetails(controller);
                return new TransformerException(transformerException.getMessage(), instructionDetails, transformerException.getException());
            }
            catch (Exception exception) {
                return transformerException;
            }
        }
        return transformerException;
    }

    protected TransformerException styleError(String string, Controller controller) {
        InstructionDetails instructionDetails = this.getInstructionDetails(controller);
        return new TransformerException(string, instructionDetails);
    }

    protected void recoverableError(String string, Controller controller) throws TransformerException {
        InstructionDetails instructionDetails = this.getInstructionDetails(controller);
        controller.recoverableError(string, instructionDetails);
    }
}

