/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import javax.xml.transform.TransformerException;
import net.sf.saxon.Controller;
import net.sf.saxon.event.NoOpenStartTagException;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.SkipInstructionException;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;

public class CopyOf
extends Instruction {
    private Expression select;
    private boolean copyNamespaces;
    private boolean copyAnnotations;

    public CopyOf(Expression expression, boolean bl, boolean bl2) {
        this.select = expression;
        this.copyNamespaces = bl;
        this.copyAnnotations = bl2;
    }

    public String getInstructionName() {
        return "xsl:copy-of";
    }

    public TailCall processLeavingTail(XPathContext xPathContext) throws TransformerException {
        Controller controller = xPathContext.getController();
        SequenceReceiver sequenceReceiver = controller.getReceiver();
        int n = this.copyNamespaces ? 2 : 0;
        SequenceIterator sequenceIterator = this.select.iterate(xPathContext);
        while (sequenceIterator.hasNext()) {
            Item item = sequenceIterator.next();
            if (item instanceof NodeInfo) {
                try {
                    ((NodeInfo)item).copy(sequenceReceiver, n, this.copyAnnotations);
                }
                catch (NoOpenStartTagException noOpenStartTagException) {
                    this.recoverableError("Cannot write a namespace or attribute node when no element start tag is open", controller);
                }
                catch (SkipInstructionException skipInstructionException) {
                    this.recoverableError(skipInstructionException.getMessage(), controller);
                }
                continue;
            }
            sequenceReceiver.characters(item.getStringValue(), 0);
        }
        return null;
    }
}

