/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import javax.xml.transform.TransformerException;
import net.sf.saxon.Controller;
import net.sf.saxon.event.NoOpenStartTagException;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.AttributeSet;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;

public class Copy
extends Instruction {
    private AttributeSet[] useAttributeSets;
    private boolean copyNamespaces;

    public Copy(AttributeSet[] attributeSetArray, boolean bl) {
        this.useAttributeSets = attributeSetArray;
        this.copyNamespaces = bl;
    }

    public String getInstructionName() {
        return "xsl:copy";
    }

    public TailCall processLeavingTail(XPathContext xPathContext) throws TransformerException {
        Controller controller = xPathContext.getController();
        SequenceReceiver sequenceReceiver = controller.getReceiver();
        Item item = controller.getCurrentItem();
        if (!(item instanceof NodeInfo)) {
            sequenceReceiver.characters(item.getStringValue(), 0);
            return null;
        }
        NodeInfo nodeInfo = (NodeInfo)item;
        switch (nodeInfo.getItemType()) {
            case 1: {
                sequenceReceiver.startElement(nodeInfo.getNameCode(), 0, 0);
                if (this.copyNamespaces) {
                    nodeInfo.outputNamespaceNodes(sequenceReceiver, true);
                }
                if (this.useAttributeSets != null) {
                    AttributeSet.expand(this.useAttributeSets, xPathContext);
                }
                this.processChildren(xPathContext);
                sequenceReceiver.endElement();
                break;
            }
            case 2: {
                int n = nodeInfo.getNameCode();
                try {
                    sequenceReceiver.attribute(n, 0, nodeInfo.getStringValue(), 0);
                }
                catch (NoOpenStartTagException noOpenStartTagException) {
                    this.recoverableError("Cannot write an attribute node when no element start tag is open", controller);
                }
                break;
            }
            case 3: {
                sequenceReceiver.characters(nodeInfo.getStringValue(), 0);
                break;
            }
            case 7: {
                sequenceReceiver.processingInstruction(nodeInfo.getDisplayName(), nodeInfo.getStringValue(), 0);
                break;
            }
            case 8: {
                sequenceReceiver.comment(nodeInfo.getStringValue(), 0);
                break;
            }
            case 13: {
                try {
                    nodeInfo.copy(sequenceReceiver, 0, false);
                }
                catch (NoOpenStartTagException noOpenStartTagException) {
                    this.recoverableError("Cannot write a namespace node when no element start tag is open", controller);
                }
                break;
            }
            case 9: {
                this.processChildren(xPathContext);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown node type " + nodeInfo.getItemType());
            }
        }
        return null;
    }
}

