/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.xpath.XPathException;

public class Translate
extends SystemFunction {
    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        StringValue stringValue = (StringValue)this.argument[0].evaluateItem(xPathContext);
        if (stringValue == null) {
            return null;
        }
        String string = stringValue.getStringValue();
        stringValue = (StringValue)this.argument[1].evaluateItem(xPathContext);
        if (stringValue == null) {
            return null;
        }
        String string2 = stringValue.getStringValue();
        stringValue = (StringValue)this.argument[2].evaluateItem(xPathContext);
        if (stringValue == null) {
            return null;
        }
        String string3 = stringValue.getStringValue();
        return new StringValue(Translate.translate(string, string2, string3));
    }

    private static CharSequence translate(String string, String string2, String string3) {
        int n = StringValue.getLength(string);
        int n2 = StringValue.getLength(string2);
        int n3 = StringValue.getLength(string3);
        if (string.length() != n || string2.length() != n2 || string3.length() != n3) {
            return Translate.slowTranslate(string, string2, string3);
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n4 = string3.length();
        int n5 = 0;
        while (n5 < string.length()) {
            char c = string.charAt(n5);
            int n6 = string2.indexOf(c);
            if (n6 < n4) {
                stringBuffer.append(n6 < 0 ? c : string3.charAt(n6));
            }
            ++n5;
        }
        return stringBuffer;
    }

    private static CharSequence slowTranslate(String string, String string2, String string3) {
        int[] nArray = StringValue.expand(string);
        int[] nArray2 = StringValue.expand(string2);
        int[] nArray3 = StringValue.expand(string3);
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < nArray.length) {
            int n2 = nArray[n];
            int n3 = -1;
            int n4 = 0;
            while (n4 < nArray2.length) {
                if (nArray2[n4] == n2) {
                    n3 = n4;
                    break;
                }
                ++n4;
            }
            int n5 = -1;
            if (n3 < 0) {
                n5 = nArray[n];
            } else if (n3 < nArray3.length) {
                n5 = nArray3[n3];
            }
            if (n5 >= 0) {
                if (n5 < 65536) {
                    stringBuffer.append((char)n5);
                } else {
                    stringBuffer.append((char)((n5 -= 65536) / 1024 + 55296));
                    stringBuffer.append((char)(n5 % 1024 + 56320));
                }
            }
            ++n;
        }
        return stringBuffer;
    }
}

