/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Navigator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.value.Type;
import net.sf.saxon.xpath.XPathException;

public class Trace
extends SystemFunction {
    public Expression preEvaluate(StaticContext staticContext) {
        return this;
    }

    public int computeSpecialProperties() {
        return this.argument[0].getSpecialProperties();
    }

    public int computeCardinality() {
        return this.argument[0].getCardinality();
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        Item item = this.argument[0].evaluateItem(xPathContext);
        String string = this.argument[1].evaluateAsString(xPathContext);
        this.traceItem(item, string);
        return item;
    }

    private void traceItem(Item item, String string) throws XPathException {
        if (item == null) {
            System.err.println(string + ": empty sequence");
        } else if (item instanceof NodeInfo) {
            System.err.println(string + ": " + Type.getTypeName(item.getItemType()) + ": " + Navigator.getPath((NodeInfo)item));
        } else {
            System.err.println(string + ": " + Type.getTypeName(item.getItemType()) + ": " + item.getStringValue());
        }
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        return new TracingIterator(this.argument[0].iterate(xPathContext), this.argument[1].evaluateAsString(xPathContext));
    }

    public class TracingIterator
    implements SequenceIterator {
        SequenceIterator base;
        String label;

        public TracingIterator(SequenceIterator sequenceIterator, String string) throws XPathException {
            this.base = sequenceIterator;
            this.label = string;
            if (!sequenceIterator.hasNext()) {
                Trace.this.traceItem(null, string);
            }
        }

        public boolean hasNext() throws XPathException {
            return this.base.hasNext();
        }

        public Item next() throws XPathException {
            Item item = this.base.next();
            Trace.this.traceItem(item, this.label + " [" + this.position() + "]");
            return item;
        }

        public Item current() {
            return this.base.current();
        }

        public int position() {
            return this.base.position();
        }

        public SequenceIterator getAnother() throws XPathException {
            return new TracingIterator(this.base.getAnother(), this.label);
        }
    }
}

