/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.Version;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.functions.XSLTFunction;
import net.sf.saxon.instruct.NamespaceContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Name;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.style.ExpressionContext;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.xpath.XPathException;

public class SystemProperty
extends SystemFunction
implements XSLTFunction {
    private NamespaceContext nsContext;

    public void checkArguments(StaticContext staticContext) throws XPathException {
        super.checkArguments(staticContext);
        if (!(this.argument[0] instanceof StringValue)) {
            this.nsContext = ((ExpressionContext)staticContext).getNamespaceContext();
        }
    }

    public Expression preEvaluate(StaticContext staticContext) throws XPathException {
        String string = ((StringValue)this.argument[0]).getStringValue();
        try {
            String[] stringArray = Name.getQNameParts(string);
            String string2 = stringArray[0];
            String string3 = stringArray[1];
            String string4 = string2.equals("") ? "" : staticContext.getURIForPrefix(string2);
            return new StringValue(SystemProperty.getProperty(string4, string3));
        }
        catch (QNameException qNameException) {
            throw new XPathException.Static("Invalid system property name. " + qNameException.getMessage());
        }
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        String string = this.argument[0].evaluateItem(xPathContext).getStringValue();
        try {
            String[] stringArray = Name.getQNameParts(string);
            String string2 = stringArray[0];
            String string3 = stringArray[1];
            String string4 = string2.equals("") ? "" : this.nsContext.getURIForPrefix(string2, false, xPathContext.getController().getNamePool());
            return new StringValue(SystemProperty.getProperty(string4, string3));
        }
        catch (QNameException qNameException) {
            this.dynamicError("Invalid system property name. " + qNameException.getMessage());
            return null;
        }
    }

    public static String getProperty(String string, String string2) {
        if (string.equals("http://www.w3.org/1999/XSL/Transform")) {
            if (string2.equals("version")) {
                return Version.getXSLVersionString();
            }
            if (string2.equals("vendor")) {
                return Version.getProductTitle();
            }
            if (string2.equals("vendor-url")) {
                return Version.getWebSiteAddress();
            }
            if (string2.equals("product-name")) {
                return Version.getProductName();
            }
            if (string2.equals("product-version")) {
                return Version.getProductVersion();
            }
            if (string2.equals("is-schema-aware")) {
                return "no";
            }
            if (string2.equals("supports-serialization")) {
                return "yes";
            }
            if (string2.equals("supports-backwards-compatibility")) {
                return "yes";
            }
            return "";
        }
        if (string.equals("")) {
            String string3 = System.getProperty(string2);
            if (string3 == null) {
                string3 = "";
            }
            return string3;
        }
        return "";
    }
}

