/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.io.StringWriter;
import java.util.Properties;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.Controller;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.functions.XSLTFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.style.ExpressionContext;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.xpath.XPathException;

public class Serialize
extends SystemFunction
implements XSLTFunction {
    Properties outputProperties;

    public void checkArguments(StaticContext staticContext) throws XPathException {
        super.checkArguments(staticContext);
        if (!(staticContext instanceof ExpressionContext)) {
            throw new XPathException.Static("saxon:serialize is available only within XSLT");
        }
        if (!(this.argument[1] instanceof StringValue)) {
            throw new XPathException.Static("Second argument of saxon:serialize must be known at compile time");
        }
        String string = ((StringValue)this.argument[1]).getStringValue();
        int n = -1;
        if (!string.equals("") && (n = ((ExpressionContext)staticContext).getFingerprint(string, false)) == -1) {
            throw new XPathException.Static("Output format '" + string + "' has not been defined");
        }
        try {
            this.outputProperties = ((ExpressionContext)staticContext).getXSLStyleSheet().gatherOutputProperties(n);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new XPathException.Static(transformerConfigurationException);
        }
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        NodeInfo nodeInfo = (NodeInfo)this.argument[0].evaluateItem(xPathContext);
        if (nodeInfo == null) {
            return StringValue.EMPTY_STRING;
        }
        try {
            StringWriter stringWriter = new StringWriter();
            Controller controller = xPathContext.getController();
            SequenceReceiver sequenceReceiver = controller.getReceiver();
            controller.changeOutputDestination(this.outputProperties, new StreamResult(stringWriter), false);
            nodeInfo.copy(controller.getReceiver(), 2, true);
            controller.resetOutputDestination(sequenceReceiver);
            return new StringValue(stringWriter.toString());
        }
        catch (TransformerException transformerException) {
            throw new XPathException.Dynamic(transformerException);
        }
    }
}

