/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.io.StringReader;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.SAXSource;
import net.sf.saxon.Controller;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.Sender;
import net.sf.saxon.event.Stripper;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.functions.XSLTFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.style.ExpressionContext;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.xpath.XPathException;
import org.xml.sax.InputSource;

public class Parse
extends SystemFunction
implements XSLTFunction {
    String baseURI;

    public void checkArguments(StaticContext staticContext) throws XPathException {
        super.checkArguments(staticContext);
        if (!(staticContext instanceof ExpressionContext)) {
            throw new XPathException.Static("saxon:parse is available only within XSLT");
        }
        this.baseURI = staticContext.getBaseURI();
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        Controller controller = xPathContext.getController();
        StringValue stringValue = (StringValue)this.argument[0].evaluateItem(xPathContext);
        StringReader stringReader = new StringReader(stringValue.getStringValue());
        InputSource inputSource = new InputSource(stringReader);
        inputSource.setSystemId(this.baseURI);
        SAXSource sAXSource = new SAXSource(inputSource);
        sAXSource.setSystemId(this.baseURI);
        Builder builder = controller.makeBuilder();
        Stripper stripper = controller.makeStripper(builder);
        try {
            new Sender(controller.getConfiguration()).send(sAXSource, stripper, controller.getNamePool(), false);
            return builder.getCurrentDocument();
        }
        catch (TransformerException transformerException) {
            throw new XPathException.Dynamic(transformerException);
        }
    }
}

