/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.io.Serializable;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.functions.XSLTFunction;
import net.sf.saxon.instruct.NamespaceContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Name;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.style.ExpressionContext;
import net.sf.saxon.trans.DecimalFormatManager;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.xpath.XPathException;

public class FormatNumber2
extends SystemFunction
implements XSLTFunction {
    private NamespaceContext nsContext = null;
    private DecimalFormatSymbols decimalFormatSymbols = null;
    private transient String picture = null;
    private SubPicture[] subPictures = null;
    private boolean requireFixup = false;

    public void checkArguments(StaticContext staticContext) throws XPathException {
        super.checkArguments(staticContext);
        if (this.argument[1] instanceof StringValue) {
            this.picture = ((StringValue)this.argument[1]).getStringValue();
        }
        if (this.getNumberOfArguments() == 3) {
            if (this.argument[2] instanceof StringValue) {
                Object object;
                String string = ((StringValue)this.argument[2]).getStringValue();
                String string2 = null;
                String string3 = null;
                try {
                    object = Name.getQNameParts(string);
                    string2 = object[1];
                    string3 = staticContext.getURIForPrefix(object[0]);
                }
                catch (QNameException qNameException) {
                    throw new XPathException.Static("Invalid decimal format name. " + qNameException.getMessage());
                }
                object = ((ExpressionContext)staticContext).getXSLStyleSheet().getDecimalFormatManager();
                this.requireFixup = true;
                ((DecimalFormatManager)object).registerUsage(string3, string2, this);
            } else {
                this.nsContext = ((ExpressionContext)staticContext).getNamespaceContext();
            }
        } else {
            DecimalFormatManager decimalFormatManager = ((ExpressionContext)staticContext).getXSLStyleSheet().getDecimalFormatManager();
            decimalFormatManager.registerUsage("", "", this);
        }
    }

    public void fixup(DecimalFormatSymbols decimalFormatSymbols) {
        block2: {
            this.requireFixup = false;
            this.decimalFormatSymbols = decimalFormatSymbols;
            if (this.picture == null) break block2;
            try {
                this.subPictures = this.getSubPictures(this.picture, decimalFormatSymbols);
            }
            catch (XPathException xPathException) {
                this.subPictures = null;
            }
        }
    }

    private SubPicture[] getSubPictures(String string, DecimalFormatSymbols decimalFormatSymbols) throws XPathException {
        SubPicture[] subPictureArray = new SubPicture[2];
        int n = string.indexOf(decimalFormatSymbols.getPatternSeparator());
        if (n < 0) {
            subPictureArray[0] = new SubPicture(string, decimalFormatSymbols);
            subPictureArray[1] = null;
        } else {
            subPictureArray[0] = new SubPicture(string.substring(0, n), decimalFormatSymbols);
            subPictureArray[1] = new SubPicture(string.substring(n + 1), decimalFormatSymbols);
        }
        return subPictureArray;
    }

    public Expression preEvaluate(StaticContext staticContext) {
        return this;
    }

    public String evaluateAsString(XPathContext xPathContext) throws XPathException {
        String string;
        Object object;
        int n = this.getNumberOfArguments();
        Controller controller = xPathContext.getController();
        DecimalFormatSymbols decimalFormatSymbols = this.decimalFormatSymbols;
        NumericValue numericValue = (NumericValue)this.argument[0].evaluateItem(xPathContext);
        if (decimalFormatSymbols == null) {
            if (this.requireFixup) {
                this.dynamicError("Unknown decimal format name");
                return null;
            }
            object = controller.getDecimalFormatManager();
            if (n == 2) {
                decimalFormatSymbols = ((DecimalFormatManager)object).getDefaultDecimalFormat();
            } else {
                string = this.argument[2].evaluateItem(xPathContext).getStringValue();
                try {
                    String[] stringArray = Name.getQNameParts(string);
                    String string2 = stringArray[1];
                    String string3 = this.nsContext.getURIForPrefix(stringArray[0], false, xPathContext.getController().getNamePool());
                    if (string3 == null) {
                        this.dynamicError("Namespace prefix '" + stringArray[0] + "' has not been defined");
                        return null;
                    }
                    decimalFormatSymbols = ((DecimalFormatManager)object).getNamedDecimalFormat(string3, string2);
                    if (decimalFormatSymbols == null) {
                        this.dynamicError("format-number function: decimal-format '" + string2 + "' is not defined");
                        return null;
                    }
                }
                catch (QNameException qNameException) {
                    this.dynamicError("Invalid decimal format name. " + qNameException.getMessage());
                }
            }
        }
        if ((object = this.subPictures) == null) {
            string = this.argument[1].evaluateItem(xPathContext).getStringValue();
            object = this.getSubPictures(string, decimalFormatSymbols);
        }
        return this.formatNumber(numericValue.asDouble(), (SubPicture[])object, decimalFormatSymbols);
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        return new StringValue(this.evaluateAsString(xPathContext));
    }

    private String formatNumber(double d, SubPicture[] subPictureArray, DecimalFormatSymbols decimalFormatSymbols) {
        SubPicture subPicture;
        String string = "";
        if (d < 0.0) {
            if (subPictureArray[1] == null) {
                subPicture = subPictureArray[0];
                string = "" + decimalFormatSymbols.getMinusSign();
            } else {
                subPicture = subPictureArray[1];
            }
        } else {
            subPicture = subPictureArray[0];
        }
        return subPicture.format(Math.abs(d), decimalFormatSymbols, string);
    }

    private void grumble(String string) throws XPathException {
        this.dynamicError("format-number picture: " + string);
    }

    private class SubPicture
    implements Serializable {
        int minWholePartSize = 0;
        int maxWholePartSize = 0;
        int minFractionPartSize = 0;
        int maxFractionPartSize = 0;
        boolean isPercent = false;
        boolean isPerMille = false;
        String prefix = "";
        String suffix = "";
        int[] wholePartGroupingPositions = null;
        int[] fractionalPartGroupingPositions = null;

        public SubPicture(String string, DecimalFormatSymbols decimalFormatSymbols) throws XPathException {
            int n;
            int n2;
            char c = decimalFormatSymbols.getPercent();
            char c2 = decimalFormatSymbols.getPerMill();
            char c3 = decimalFormatSymbols.getDecimalSeparator();
            char c4 = decimalFormatSymbols.getGroupingSeparator();
            char c5 = decimalFormatSymbols.getDigit();
            char c6 = decimalFormatSymbols.getZeroDigit();
            ArrayList<Integer> arrayList = null;
            ArrayList<Integer> arrayList2 = null;
            int n3 = 0;
            int n4 = 0;
            while (n4 < string.length()) {
                n2 = string.charAt(n4);
                if (n2 == c || n2 == c2) {
                    if (this.isPercent || this.isPerMille) {
                        FormatNumber2.this.grumble("Cannot have more than one percent or per-mille character in a sub-picture");
                    }
                    this.isPercent = n2 == c;
                    this.isPerMille = n2 == c2;
                    switch (n3) {
                        case 0: {
                            this.prefix = this.prefix + (char)n2;
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: {
                            n3 = 5;
                            this.suffix = this.suffix + (char)n2;
                        }
                    }
                } else if (n2 == c5) {
                    switch (n3) {
                        case 0: 
                        case 1: {
                            n3 = 1;
                            ++this.maxWholePartSize;
                            break;
                        }
                        case 2: {
                            FormatNumber2.this.grumble("Digit sign must not appear after a zero-digit sign in the integer part of a sub-picture");
                            break;
                        }
                        case 3: 
                        case 4: {
                            n3 = 4;
                            ++this.maxFractionPartSize;
                            break;
                        }
                        case 5: {
                            FormatNumber2.this.grumble("Passive character must not appear between active characters in a sub-picture");
                        }
                    }
                } else if (n2 == c6) {
                    switch (n3) {
                        case 0: 
                        case 1: 
                        case 2: {
                            n3 = 2;
                            ++this.minWholePartSize;
                            ++this.maxWholePartSize;
                            break;
                        }
                        case 3: {
                            ++this.minFractionPartSize;
                            ++this.maxFractionPartSize;
                            break;
                        }
                        case 4: {
                            FormatNumber2.this.grumble("Zero digit sign must not appear after a digit sign in the fractional part of a sub-picture");
                            break;
                        }
                        case 5: {
                            FormatNumber2.this.grumble("Passive character must not appear between active characters in a sub-picture");
                        }
                    }
                } else if (n2 == c3) {
                    switch (n3) {
                        case 0: 
                        case 1: 
                        case 2: {
                            n3 = 3;
                            break;
                        }
                        case 3: 
                        case 4: 
                        case 5: {
                            FormatNumber2.this.grumble("There must only be one decimal separator in a sub-picture");
                        }
                    }
                } else if (n2 == c4) {
                    switch (n3) {
                        case 0: 
                        case 1: 
                        case 2: {
                            if (arrayList == null) {
                                arrayList = new ArrayList<Integer>();
                            }
                            arrayList.add(new Integer(this.maxWholePartSize));
                            break;
                        }
                        case 3: 
                        case 4: {
                            if (this.maxFractionPartSize == 0) {
                                FormatNumber2.this.grumble("Grouping separator cannot be adjacent to decimal separator");
                            }
                            if (arrayList2 == null) {
                                arrayList2 = new ArrayList<Integer>();
                            }
                            arrayList2.add(new Integer(this.maxFractionPartSize));
                            break;
                        }
                        case 5: {
                            FormatNumber2.this.grumble("Grouping separator found in suffix of sub-picture");
                        }
                    }
                } else {
                    switch (n3) {
                        case 0: {
                            this.prefix = this.prefix + (char)n2;
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: {
                            n3 = 5;
                            this.suffix = this.suffix + (char)n2;
                        }
                    }
                }
                ++n4;
            }
            if (arrayList != null) {
                n2 = arrayList.size();
                this.wholePartGroupingPositions = new int[n2];
                n = 0;
                while (n < n2) {
                    this.wholePartGroupingPositions[n] = this.maxWholePartSize - (Integer)arrayList.get(n2 - n - 1);
                    ++n;
                }
                if (n2 > 1) {
                    boolean bl = true;
                    int n5 = this.wholePartGroupingPositions[0];
                    int n6 = 1;
                    while (n6 < n2) {
                        if (this.wholePartGroupingPositions[n6] != n6 * n5) {
                            bl = false;
                            break;
                        }
                        ++n6;
                    }
                    if (bl) {
                        this.wholePartGroupingPositions = new int[1];
                        this.wholePartGroupingPositions[0] = n5;
                    }
                }
                if (this.wholePartGroupingPositions[0] == 0) {
                    FormatNumber2.this.grumble("Cannot have a grouping separator adjacent to the decimal separator");
                }
            }
            if (arrayList2 != null) {
                n2 = arrayList2.size();
                this.fractionalPartGroupingPositions = new int[n2];
                n = 0;
                while (n < n2) {
                    this.fractionalPartGroupingPositions[n] = (Integer)arrayList2.get(n);
                    ++n;
                }
            }
        }

        public String format(double d, DecimalFormatSymbols decimalFormatSymbols, String string) {
            int n;
            int n2;
            if (Double.isNaN(d)) {
                return this.prefix + decimalFormatSymbols.getNaN() + this.suffix;
            }
            if (Double.isInfinite(d)) {
                return this.prefix + string + decimalFormatSymbols.getInfinity() + this.suffix;
            }
            if (this.isPercent) {
                d = 100.0 * d;
            } else if (this.isPerMille) {
                d = 1000.0 * d;
            }
            StringBuffer stringBuffer = new StringBuffer();
            double d2 = d * Math.pow(10.0, this.maxFractionPartSize);
            long l = (long)d2;
            double d3 = d2 - (double)l;
            if (d3 > 0.5) {
                ++l;
            } else if (d3 == 0.5 && (l & 1L) == 1L) {
                ++l;
            }
            String string2 = "" + l;
            int n3 = string2.length() - this.maxFractionPartSize;
            if (n3 > 0) {
                stringBuffer.append(string2.substring(0, n3));
            }
            int n4 = stringBuffer.length();
            stringBuffer.append('.');
            while (n3 < 0) {
                stringBuffer.append('0');
                ++n3;
            }
            stringBuffer.append(string2.substring(n3));
            while (n4 < this.minWholePartSize) {
                stringBuffer.insert(0, '0');
                ++n4;
            }
            while (n4 > this.maxWholePartSize) {
                if (stringBuffer.charAt(0) != '0') break;
                stringBuffer.deleteCharAt(0);
                --n4;
            }
            int n5 = stringBuffer.length() - n4 - 1;
            while (n5 > this.minFractionPartSize) {
                if (stringBuffer.charAt(stringBuffer.length() - 1) != '0') break;
                stringBuffer.deleteCharAt(stringBuffer.length() - 1);
                --n5;
            }
            if (decimalFormatSymbols.getDecimalSeparator() != '.') {
                stringBuffer.setCharAt(n4, decimalFormatSymbols.getDecimalSeparator());
            }
            if (this.maxFractionPartSize == 0) {
                stringBuffer.deleteCharAt(n4);
            }
            if (decimalFormatSymbols.getZeroDigit() != '0') {
                n2 = decimalFormatSymbols.getZeroDigit();
                n = 0;
                while (n < stringBuffer.length()) {
                    char c = stringBuffer.charAt(n);
                    if (c >= '0' && c <= '9') {
                        stringBuffer.setCharAt(n, (char)(c - 48 + n2));
                    }
                    ++n;
                }
            }
            if (this.wholePartGroupingPositions != null) {
                if (this.wholePartGroupingPositions.length == 1) {
                    n2 = this.wholePartGroupingPositions[0];
                    n = n4 - n2;
                    while (n > 0) {
                        stringBuffer.insert(n, decimalFormatSymbols.getGroupingSeparator());
                        n -= n2;
                    }
                } else {
                    n2 = 0;
                    while (n2 < this.wholePartGroupingPositions.length) {
                        n = n4 - this.wholePartGroupingPositions[n2];
                        if (n > 0) {
                            stringBuffer.insert(n, decimalFormatSymbols.getGroupingSeparator());
                        }
                        ++n2;
                    }
                }
            }
            if (this.fractionalPartGroupingPositions != null) {
                n2 = 0;
                while (n2 < this.fractionalPartGroupingPositions.length) {
                    n = n4 + 1 + this.fractionalPartGroupingPositions[n2] + n2;
                    if (n < stringBuffer.length() - 1) {
                        stringBuffer.insert(n, decimalFormatSymbols.getGroupingSeparator());
                    }
                    ++n2;
                }
            }
            stringBuffer.insert(0, string + this.prefix);
            stringBuffer.append(this.suffix);
            return stringBuffer.toString();
        }
    }
}

