/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.functions.XSLTFunction;
import net.sf.saxon.number.Numberer_en;
import net.sf.saxon.om.Item;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.xpath.XPathException;

public class FormatDate
extends SystemFunction
implements XSLTFunction {
    public void checkArguments(StaticContext staticContext) throws XPathException {
        super.checkArguments(staticContext);
    }

    public Expression preEvaluate(StaticContext staticContext) {
        return this;
    }

    public String evaluateAsString(XPathContext xPathContext) throws XPathException {
        AtomicValue atomicValue = (AtomicValue)this.argument[0].evaluateItem(xPathContext);
        DateTimeValue dateTimeValue = (DateTimeValue)atomicValue.convert(107);
        String string = this.argument[1].evaluateItem(xPathContext).getStringValue();
        return FormatDate.formatDate(dateTimeValue, string);
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        return new StringValue(this.evaluateAsString(xPathContext));
    }

    private static String formatDate(DateTimeValue dateTimeValue, String string) throws XPathException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (true) {
            if (n < string.length() && string.charAt(n) != '[') {
                stringBuffer.append(string.charAt(n));
                if (string.charAt(n) == ']' && (++n == string.length() || string.charAt(n) != ']')) {
                    throw new XPathException.Dynamic("Closing ']' in date picture must be written as ']]'");
                }
                ++n;
                continue;
            }
            if (n == string.length()) break;
            if (string.charAt(++n) == '[') {
                stringBuffer.append('[');
                ++n;
                continue;
            }
            int n2 = string.indexOf("]", n);
            if (n2 == -1) {
                throw new XPathException.Dynamic("Date format contains a '[' with no matching ']'");
            }
            String string2 = string.substring(n, n2);
            stringBuffer.append(FormatDate.formatComponent(dateTimeValue, string2.trim()));
            n = n2 + 1;
        }
        return stringBuffer.toString();
    }

    private static String formatComponent(DateTimeValue dateTimeValue, String string) throws XPathException {
        Date date = dateTimeValue.getUTCDate();
        Calendar calendar = dateTimeValue.getCalendar();
        switch (string.charAt(0)) {
            case 'Y': {
                return FormatDate.formatNumber(calendar.get(1), string, 4);
            }
            case 'D': {
                return FormatDate.formatNumber(calendar.get(5), string, 1);
            }
            case 'd': {
                return FormatDate.formatNumber(calendar.get(6), string, 1);
            }
            case 'W': {
                return FormatDate.formatNumber(calendar.get(3), string, 1);
            }
            case 'w': {
                return FormatDate.formatNumber(calendar.get(4), string, 1);
            }
            case 'H': {
                return FormatDate.formatNumber(calendar.get(11), string, 2);
            }
            case 'h': {
                return FormatDate.formatNumber(calendar.get(10), string, 2);
            }
            case 'm': {
                return FormatDate.formatNumber(calendar.get(12), string, 2);
            }
            case 's': {
                return FormatDate.formatNumber(calendar.get(13), string, 2);
            }
            case 'f': {
                return FormatDate.formatNumber(calendar.get(14), string, 3);
            }
            case 'Z': 
            case 'z': {
                StringBuffer stringBuffer = new StringBuffer();
                DateTimeValue.appendTimezone(calendar, stringBuffer);
                return stringBuffer.toString();
            }
            case 'M': {
                return FormatDate.formatMonth(date, calendar, string);
            }
            case 'F': {
                return FormatDate.formatDayOfWeek(date, calendar, string);
            }
            case 'P': {
                return FormatDate.formatAmPm(date, calendar, string);
            }
            case 'C': {
                return "Gregorian";
            }
            case 'E': {
                return "*AD*";
            }
        }
        throw new XPathException.Dynamic("Unknown date/time component specifier '" + string.charAt(0) + "'");
    }

    private static String formatNumber(int n, String string, int n2) throws XPathException {
        int n3;
        int[] nArray = FormatDate.getWidths(string);
        int n4 = nArray[0] < 0 ? n2 : nArray[0];
        int n5 = n3 = nArray[1] < 0 ? n2 : nArray[1];
        if (string.charAt(0) == 'f') {
            return (1000 + (n %= 1000) + "").substring(1);
        }
        if (string.indexOf(97) > 0 || string.indexOf(65) > 0) {
            String string2 = string.indexOf(111) > 0 ? Numberer_en.toOrdinalWords(n) : Numberer_en.toWords(n);
            if (string.indexOf(65) > 0) {
                string2 = string2.toUpperCase();
            }
            return string2;
        }
        if (string.indexOf(105) > 0) {
            return Numberer_en.toRoman(n);
        }
        if (string.indexOf(73) > 0) {
            return Numberer_en.toRoman(n).toUpperCase();
        }
        if (string.indexOf(111) > 0) {
            return Numberer_en.toOrdinal(n);
        }
        String string3 = n + "";
        while (string3.length() < n4) {
            string3 = ("00000000" + string3).substring(string3.length() + 8 - n4);
        }
        if (string3.length() > n3 && string.charAt(0) == 'Y') {
            string3 = string3.substring(string3.length() - n3);
        }
        return string3;
    }

    private static int[] getWidths(String string) throws XPathException {
        try {
            int n = string.indexOf(44);
            int n2 = -1;
            int n3 = -1;
            if (n > 0) {
                int n4 = string.indexOf(45, n);
                if (n4 < 0) {
                    String string2 = string.substring(n + 1).trim();
                    if (!string2.equals("*")) {
                        n2 = Integer.parseInt(string2);
                    }
                } else {
                    String string3;
                    String string4 = string.substring(n + 1, n4).trim();
                    if (!string4.equals("*")) {
                        n2 = Integer.parseInt(string4);
                    }
                    if (!(string3 = string.substring(n4 + 1).trim()).equals("*")) {
                        n3 = Integer.parseInt(string3);
                    }
                }
            }
            if (n2 > n3 && n3 != -1) {
                throw new XPathException.Dynamic("Minimum width in date picture exceeds maximum width");
            }
            int[] nArray = new int[]{n2, n3};
            return nArray;
        }
        catch (NumberFormatException numberFormatException) {
            throw new XPathException.Dynamic("Invalid integer as width in date picture");
        }
    }

    private static String formatMonth(Date date, Calendar calendar, String string) throws XPathException {
        boolean bl = string.indexOf(110) >= 0;
        boolean bl2 = string.indexOf(78) >= 0;
        int[] nArray = FormatDate.getWidths(string);
        if (bl || bl2) {
            StringBuffer stringBuffer = new StringBuffer();
            new SimpleDateFormat("MMMMM").format(date, stringBuffer, new FieldPosition(2));
            if (stringBuffer.length() > nArray[1] && nArray[1] > 0) {
                stringBuffer.setLength(nArray[1]);
            }
            if (bl) {
                return stringBuffer.toString();
            }
            return stringBuffer.toString().toUpperCase();
        }
        return FormatDate.formatNumber(calendar.get(2) + 1, string, 1);
    }

    private static String formatDayOfWeek(Date date, Calendar calendar, String string) throws XPathException {
        if (string.indexOf(110) >= 0) {
            StringBuffer stringBuffer = new StringBuffer();
            new SimpleDateFormat("EEEEE").format(date, stringBuffer, new FieldPosition(9));
            return stringBuffer.toString();
        }
        return FormatDate.formatNumber(calendar.get(7), string, 1);
    }

    private static String formatAmPm(Date date, Calendar calendar, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        new SimpleDateFormat("a").format(date, stringBuffer, new FieldPosition(14));
        return stringBuffer.toString();
    }
}

