/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.CollatingFunction;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.sort.AtomicComparer;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.xpath.XPathException;

public class DeepEqual
extends CollatingFunction {
    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        AtomicComparer atomicComparer = this.getAtomicComparer(2, xPathContext);
        SequenceIterator sequenceIterator = this.argument[0].iterate(xPathContext);
        SequenceIterator sequenceIterator2 = this.argument[1].iterate(xPathContext);
        boolean bl = true;
        try {
            while (sequenceIterator.hasNext()) {
                if (!sequenceIterator2.hasNext()) {
                    bl = false;
                    break;
                }
                Item item = sequenceIterator.next();
                Item item2 = sequenceIterator2.next();
                if (item instanceof NodeInfo) {
                    if (item2 instanceof NodeInfo) {
                        if (DeepEqual.deepEquals((NodeInfo)item, (NodeInfo)item2, atomicComparer)) continue;
                        bl = false;
                        break;
                    }
                    bl = false;
                    break;
                }
                if (item2 instanceof NodeInfo) {
                    bl = false;
                    break;
                }
                if (atomicComparer.comparesEqual(item, item2)) continue;
                bl = false;
                break;
            }
            bl &= !sequenceIterator2.hasNext();
        }
        catch (ClassCastException classCastException) {
            bl = false;
        }
        catch (XPathException xPathException) {
            bl = false;
        }
        return BooleanValue.get(bl);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static boolean deepEquals(NodeInfo nodeInfo, NodeInfo nodeInfo2, AtomicComparer atomicComparer) {
        if (nodeInfo.isSameNode(nodeInfo2)) {
            return true;
        }
        if (nodeInfo.getItemType() != nodeInfo2.getItemType()) {
            return false;
        }
        switch (nodeInfo.getItemType()) {
            case 1: {
                Object object;
                Object object2;
                if (nodeInfo.getFingerprint() != nodeInfo2.getFingerprint()) {
                    return false;
                }
                AxisIterator axisIterator = nodeInfo.iterateAxis((byte)2);
                AxisIterator axisIterator2 = nodeInfo2.iterateAxis((byte)2);
                if (axisIterator.getLastPosition() != axisIterator2.getLastPosition()) {
                    return false;
                }
                while (axisIterator.hasNext()) {
                    object2 = (NodeInfo)axisIterator.next();
                    object = nodeInfo2.getAttributeValue(object2.getFingerprint());
                    if (object == null) {
                        return false;
                    }
                    if (atomicComparer.comparesEqual(object, object2.getStringValue())) continue;
                    return false;
                }
            }
            case 9: {
                Object object2 = nodeInfo.iterateAxis((byte)3);
                Object object = nodeInfo2.iterateAxis((byte)3);
                do {
                    if (!object2.hasNext()) {
                        return !object.hasNext();
                    }
                    if (object.hasNext()) continue;
                    return false;
                } while (DeepEqual.deepEquals((NodeInfo)object2.next(), (NodeInfo)object.next(), atomicComparer));
                return false;
            }
            case 2: 
            case 7: 
            case 13: {
                if (nodeInfo.getFingerprint() != nodeInfo2.getFingerprint()) {
                    return false;
                }
            }
            case 3: 
            case 8: {
                return atomicComparer.comparesEqual(nodeInfo.getStringValue(), nodeInfo2.getStringValue());
            }
        }
        throw new IllegalArgumentException("Unknown node type");
    }
}

