/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FunctionProxy;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.StandardFunction;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.functions.XSLTFunction;
import net.sf.saxon.instruct.NamespaceContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Name;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.style.ExpressionContext;
import net.sf.saxon.style.StandardNames;
import net.sf.saxon.style.StyleNodeFactory;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Value;
import net.sf.saxon.xpath.XPathException;

public class Available
extends SystemFunction
implements XSLTFunction {
    public static final int ELEMENT_AVAILABLE = 0;
    public static final int FUNCTION_AVAILABLE = 1;
    private transient NamespaceContext nsContext;
    private transient StyleNodeFactory styleNodeFactory;

    public void checkArguments(StaticContext staticContext) throws XPathException {
        super.checkArguments(staticContext);
        if (!(this.argument[0] instanceof Value)) {
            this.nsContext = ((ExpressionContext)staticContext).getNamespaceContext();
        }
    }

    public Expression preEvaluate(StaticContext staticContext) throws XPathException {
        String string = ((StringValue)this.argument[0]).getStringValue();
        boolean bl = false;
        switch (this.operation) {
            case 0: {
                bl = ((ExpressionContext)staticContext).isElementAvailable(string);
                break;
            }
            case 1: {
                bl = ((ExpressionContext)staticContext).isFunctionAvailable(string);
            }
        }
        return BooleanValue.get(bl);
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        StringValue stringValue = (StringValue)this.argument[0].evaluateItem(xPathContext);
        String string = stringValue.getStringValue();
        String[] stringArray = null;
        try {
            stringArray = Name.getQNameParts(string);
        }
        catch (QNameException qNameException) {
            this.dynamicError(qNameException.getMessage());
        }
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        String string4 = string2.equals("") ? (this.operation == 0 ? this.nsContext.getURIForPrefix(string2, true, xPathContext.getController().getNamePool()) : "") : this.nsContext.getURIForPrefix(string2, false, xPathContext.getController().getNamePool());
        boolean bl = false;
        switch (this.operation) {
            case 0: {
                bl = this.isElementAvailable(string4, string3, xPathContext);
                break;
            }
            case 1: {
                bl = Available.isFunctionAvailable(string4, string3);
            }
        }
        return BooleanValue.get(bl);
    }

    private static boolean isFunctionAvailable(String string, String string2) {
        try {
            if (string.equals("")) {
                return StandardFunction.getFunction(string2) != null;
            }
            Class clazz = FunctionProxy.getVendorExtensionClass(string);
            if (clazz == null) {
                clazz = FunctionProxy.getImplicitJavaClass(string);
            }
            if (clazz == null) {
                return false;
            }
            FunctionProxy functionProxy = new FunctionProxy();
            functionProxy.setArguments(ComputedExpression.NO_ARGUMENTS);
            return functionProxy.setFunctionName(clazz, string2);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean isElementAvailable(String string, String string2, XPathContext xPathContext) {
        try {
            if (this.styleNodeFactory == null) {
                NamePool namePool = new NamePool();
                StandardNames standardNames = new StandardNames();
                standardNames.allocateNames(namePool);
                this.styleNodeFactory = new StyleNodeFactory(namePool, standardNames, xPathContext.getController().getConfiguration().isAllowExternalFunctions());
            }
            return this.styleNodeFactory.isElementAvailable(string, string2);
        }
        catch (Exception exception) {
            return false;
        }
    }
}

