/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.MappingFunction;
import net.sf.saxon.expr.MappingIterator;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.value.Type;
import net.sf.saxon.xpath.XPathException;

public final class ItemChecker
extends ComputedExpression
implements MappingFunction {
    private Expression sequence;
    private int requiredItemType;
    private int requiredContentType;
    private RoleLocator role;

    public ItemChecker(Expression expression, int n, int n2, RoleLocator roleLocator) {
        this.sequence = expression;
        this.requiredItemType = n;
        this.requiredContentType = n2;
        this.role = roleLocator;
    }

    public Expression simplify() throws XPathException {
        this.sequence = this.sequence.simplify();
        if (this.requiredItemType == 88) {
            return this.sequence;
        }
        return this;
    }

    public Expression analyze(StaticContext staticContext) throws XPathException {
        this.sequence = this.sequence.analyze(staticContext);
        if (this.requiredContentType == 88 && Type.isSubType(this.sequence.getItemType(), this.requiredItemType)) {
            return this.sequence;
        }
        return this;
    }

    public Expression promote(PromotionOffer promotionOffer) throws XPathException {
        this.sequence = this.sequence.promote(promotionOffer);
        return this;
    }

    public Expression[] getSubExpressions() {
        Expression[] expressionArray = new Expression[]{this.sequence};
        return expressionArray;
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        SequenceIterator sequenceIterator = this.sequence.iterate(xPathContext);
        return new MappingIterator(sequenceIterator, this, null, null);
    }

    public Object map(Item item, XPathContext xPathContext, Object object) throws XPathException {
        this.testConformance(item);
        return item;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        Item item = this.sequence.evaluateItem(xPathContext);
        if (item == null) {
            return null;
        }
        this.testConformance(item);
        return item;
    }

    private void testConformance(Item item) throws XPathException {
        int n;
        int n2 = item.getItemType();
        if (!Type.isSubType(n2, this.requiredItemType)) {
            this.typeError("Required type of " + this.role.getMessage() + " is " + Type.getTypeName(this.requiredItemType) + "; supplied value is " + Type.getTypeName(n2));
        }
        if (this.requiredContentType != 88 && !Type.isSubType(n = ((NodeInfo)item).getTypeAnnotation(), this.requiredContentType)) {
            this.typeError("Required content type of " + this.role.getMessage() + " is " + Type.getTypeName(this.requiredContentType) + "; actual content type is " + Type.getTypeName(n));
        }
    }

    public int getItemType() {
        return this.requiredItemType;
    }

    public int computeCardinality() {
        return this.sequence.getCardinality();
    }

    public int computeSpecialProperties() {
        return this.sequence.getSpecialProperties();
    }

    public void display(int n) {
        System.err.println(ExpressionTool.indent(n) + "treat as " + Type.getTypeName(this.requiredItemType));
        this.sequence.display(n + 1);
    }
}

