/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.xpath.XPathException;

public class FilterIterator
implements SequenceIterator {
    protected SequenceIterator base;
    protected Expression filter;
    private boolean pending;
    private int position = 0;
    private Item nextItem = null;
    private Item current = null;
    protected XPathContext filterContext;

    public FilterIterator(SequenceIterator sequenceIterator, Expression expression, XPathContext xPathContext) throws XPathException {
        this.base = sequenceIterator;
        this.filter = expression;
        this.filterContext = xPathContext.newContext();
        this.filterContext.setCurrentIterator(sequenceIterator);
        this.pending = true;
    }

    public boolean hasNext() throws XPathException {
        if (this.pending) {
            this.nextItem = this.getNextMatchingItem();
            this.pending = false;
        }
        return this.nextItem != null;
    }

    public Item next() throws XPathException {
        this.current = this.nextItem;
        ++this.position;
        this.pending = true;
        return this.current;
    }

    protected Item getNextMatchingItem() throws XPathException {
        while (this.base.hasNext()) {
            Item item = this.base.next();
            if (!this.matches()) continue;
            return item;
        }
        return null;
    }

    protected boolean matches() throws XPathException {
        SequenceIterator sequenceIterator = this.filter.iterate(this.filterContext);
        if (!sequenceIterator.hasNext()) {
            return false;
        }
        Item item = sequenceIterator.next();
        if (item instanceof NodeInfo) {
            return true;
        }
        if (item instanceof BooleanValue) {
            return ((BooleanValue)item).getValue() || sequenceIterator.hasNext();
        }
        if (item instanceof IntegerValue) {
            return ((IntegerValue)item).getValue() == (long)this.base.position() || sequenceIterator.hasNext();
        }
        if (item instanceof NumericValue) {
            IntegerValue integerValue = new IntegerValue(this.base.position());
            return item.equals(integerValue) || sequenceIterator.hasNext();
        }
        if (item instanceof StringValue) {
            return !item.getStringValue().equals("") || sequenceIterator.hasNext();
        }
        return true;
    }

    public Item current() {
        return this.current;
    }

    public int position() {
        return this.position;
    }

    public SequenceIterator getAnother() throws XPathException {
        return new FilterIterator(this.base.getAnother(), this.filter, this.filterContext);
    }

    public static final class Leading
    extends FilterIterator {
        boolean finished = false;

        public Leading(SequenceIterator sequenceIterator, Expression expression, XPathContext xPathContext) throws XPathException {
            super(sequenceIterator, expression, xPathContext);
        }

        protected boolean matches() throws XPathException {
            return this.filter.effectiveBooleanValue(this.filterContext);
        }

        protected Item getNextMatchingItem() throws XPathException {
            if (this.base.hasNext()) {
                Item item = this.base.next();
                if (this.matches()) {
                    return item;
                }
                return null;
            }
            return null;
        }

        public SequenceIterator getAnother() throws XPathException {
            return new Leading(this.base.getAnother(), this.filter, this.filterContext);
        }
    }

    public static final class NonNumeric
    extends FilterIterator {
        public NonNumeric(SequenceIterator sequenceIterator, Expression expression, XPathContext xPathContext) throws XPathException {
            super(sequenceIterator, expression, xPathContext);
        }

        protected boolean matches() throws XPathException {
            return this.filter.effectiveBooleanValue(this.filterContext);
        }

        public SequenceIterator getAnother() throws XPathException {
            return new NonNumeric(this.base.getAnother(), this.filter, this.filterContext);
        }
    }
}

