/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Type;
import net.sf.saxon.value.Value;
import net.sf.saxon.xpath.XPathException;

public final class CastableExpression
extends ComputedExpression {
    Expression source;
    int targetType;

    public CastableExpression(Expression expression, SequenceType sequenceType) throws XPathException {
        this.source = expression;
        this.targetType = sequenceType.getPrimaryType();
        if (sequenceType.getCardinality() != 512) {
            throw new XPathException.Static("Target of castable must not have an occurrence indicator");
        }
        if (Type.isSubType(sequenceType.getPrimaryType(), 0)) {
            throw new XPathException.Static("Target of castable must not be a node type");
        }
    }

    public Expression simplify() throws XPathException {
        this.source = this.source.simplify();
        if (this.source instanceof Value) {
            return BooleanValue.get(this.effectiveBooleanValue(null));
        }
        return this;
    }

    public Expression analyze(StaticContext staticContext) throws XPathException {
        this.source = this.source.analyze(staticContext);
        SequenceType sequenceType = new SequenceType(90, 88, this.getCardinality());
        RoleLocator roleLocator = new RoleLocator(2, "castable as", 0);
        this.source = TypeChecker.staticTypeCheck(this.source, sequenceType, false, roleLocator);
        if (Type.isSubType(this.source.getItemType(), this.targetType)) {
            return this.source;
        }
        if (this.source instanceof AtomicValue) {
            return BooleanValue.get(this.effectiveBooleanValue(null));
        }
        return this;
    }

    public Expression promote(PromotionOffer promotionOffer) throws XPathException {
        this.source = this.source.promote(promotionOffer);
        return this;
    }

    public Expression[] getSubExpressions() {
        Expression[] expressionArray = new Expression[]{this.source};
        return expressionArray;
    }

    public int getItemType() {
        return 102;
    }

    public int computeCardinality() {
        return 512;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        return BooleanValue.get(this.effectiveBooleanValue(xPathContext));
    }

    public boolean effectiveBooleanValue(XPathContext xPathContext) throws XPathException {
        try {
            Value value = ExpressionTool.eagerEvaluate(this.source, xPathContext);
            if (!(value instanceof AtomicValue)) {
                return false;
            }
            ((AtomicValue)value).convert(this.targetType);
            return true;
        }
        catch (XPathException xPathException) {
            return false;
        }
    }

    public void display(int n) {
        System.err.println(ExpressionTool.indent(n) + "castable");
        this.source.display(n + 1);
        System.err.println(ExpressionTool.indent(n + 1) + "as " + Type.getTypeName(this.targetType));
    }
}

