/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.MappingFunction;
import net.sf.saxon.expr.MappingIterator;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.xpath.XPathException;

public final class CardinalityChecker
extends ComputedExpression
implements MappingFunction {
    private Expression sequence;
    private int requiredCardinality = -1;
    private RoleLocator role;

    public CardinalityChecker(Expression expression, int n, RoleLocator roleLocator) {
        this.sequence = expression;
        this.requiredCardinality = n;
        this.role = roleLocator;
        this.computeStaticProperties();
    }

    public Expression simplify() throws XPathException {
        this.sequence = this.sequence.simplify();
        return this;
    }

    public Expression analyze(StaticContext staticContext) throws XPathException {
        this.sequence = this.sequence.analyze(staticContext);
        if (this.requiredCardinality == 1792) {
            return this.sequence;
        }
        if (Cardinality.subsumes(this.requiredCardinality, this.sequence.getCardinality())) {
            return this.sequence;
        }
        return this;
    }

    public Expression promote(PromotionOffer promotionOffer) throws XPathException {
        this.sequence = this.sequence.promote(promotionOffer);
        return this;
    }

    public Expression[] getSubExpressions() {
        Expression[] expressionArray = new Expression[]{this.sequence};
        return expressionArray;
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        SequenceIterator sequenceIterator = this.sequence.iterate(xPathContext);
        if (!sequenceIterator.hasNext() && !Cardinality.allowsZero(this.requiredCardinality)) {
            this.typeError("An empty sequence is not allowed as the " + this.role.getMessage());
            return null;
        }
        if (!Cardinality.allowsMany(this.requiredCardinality)) {
            return new MappingIterator(sequenceIterator, this, null, sequenceIterator);
        }
        return sequenceIterator;
    }

    public Object map(Item item, XPathContext xPathContext, Object object) throws XPathException {
        if (((SequenceIterator)object).position() == 2) {
            this.typeError("A sequence of more than one item is not allowed as the " + this.role.getMessage());
            return null;
        }
        return item;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        SequenceIterator sequenceIterator = this.sequence.iterate(xPathContext);
        if (!sequenceIterator.hasNext()) {
            if ((this.requiredCardinality & 0x100) == 0) {
                this.typeError("An empty sequence is not allowed as the " + this.role.getMessage());
            }
            return null;
        }
        Item item = sequenceIterator.next();
        if (!Cardinality.allowsMany(this.requiredCardinality) && sequenceIterator.hasNext()) {
            this.typeError("A sequence of more than one item is not allowed as the " + this.role.getMessage());
            return null;
        }
        return item;
    }

    public int getItemType() {
        return this.sequence.getItemType();
    }

    public int computeCardinality() {
        return this.requiredCardinality;
    }

    public int computeSpecialProperties() {
        return this.sequence.getSpecialProperties();
    }

    public void display(int n) {
        System.err.println(ExpressionTool.indent(n) + "checkCardinality (" + Cardinality.toString(this.requiredCardinality) + ")");
        this.sequence.display(n + 1);
    }
}

