/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.AttributeReference;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.ParentNodeExpression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Axis;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.xpath.XPathException;

public final class AxisExpression
extends ComputedExpression {
    private byte axis;
    private NodeTest test;

    public AxisExpression(byte by, NodeTest nodeTest) {
        this.axis = by;
        this.test = nodeTest;
    }

    public Expression simplify() {
        ComputedExpression computedExpression = this;
        if (this.axis == 2 && this.test instanceof NameTest) {
            computedExpression = new AttributeReference(this.test.getFingerprint());
            ExpressionTool.copyLocationInfo(this, computedExpression);
        }
        if (this.axis == 9 && (this.test == null || this.test instanceof AnyNodeTest)) {
            computedExpression = new ParentNodeExpression();
            ExpressionTool.copyLocationInfo(this, computedExpression);
        }
        return computedExpression;
    }

    public Expression analyze(StaticContext staticContext) throws XPathException {
        return this;
    }

    public boolean equals(Object object) {
        if (!(object instanceof AxisExpression)) {
            return false;
        }
        if (this.axis != ((AxisExpression)object).axis) {
            return false;
        }
        if (this.test == null && ((AxisExpression)object).test == null) {
            return true;
        }
        return this.test.toString().equals(((AxisExpression)object).test.toString());
    }

    public int hashCode() {
        int n = 9375162 + this.axis << 20;
        if (this.test != null) {
            n ^= this.test.getItemType() << 16;
            n ^= this.test.getFingerprint();
        }
        return n;
    }

    public int getIntrinsicDependencies() {
        return 2;
    }

    public int computeSpecialProperties() {
        return 0x10000 | (Axis.isForwards[this.axis] ? 131072 : 262144) | (Axis.isPeerAxis[this.axis] ? 524288 : 0) | (Axis.isSubtreeAxis[this.axis] ? 0x100000 : 0) | (this.axis == 2 || this.axis == 8 ? 0x200000 : 0);
    }

    public final int getItemType() {
        short s = Axis.principalNodeType[this.axis];
        if (s == 2 || s == 13) {
            return s;
        }
        if (this.test == null) {
            return 0;
        }
        return this.test.getItemType();
    }

    public final int computeCardinality() {
        return 1792;
    }

    protected byte getAxis() {
        return this.axis;
    }

    protected NodeTest getNodeTest() {
        return this.test;
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        NodeInfo nodeInfo = (NodeInfo)xPathContext.getContextItem();
        if (nodeInfo == null) {
            this.dynamicError("The context item for an axis step is not set");
        }
        try {
            if (this.test == null) {
                return nodeInfo.iterateAxis(this.axis);
            }
            return nodeInfo.iterateAxis(this.axis, this.test);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            this.dynamicError(unsupportedOperationException.getMessage());
            return null;
        }
    }

    public void display(int n) {
        System.err.println(ExpressionTool.indent(n) + Axis.axisName[this.axis] + "::" + (this.test == null ? "node()" : this.test.toString()));
    }
}

