/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.MappingFunction;
import net.sf.saxon.expr.MappingIterator;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Type;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.xpath.XPathException;

public final class Atomizer
extends ComputedExpression
implements MappingFunction {
    private Expression sequence;
    private int requiredItemType = -1;

    public Atomizer(Expression expression) {
        this.sequence = expression;
    }

    public Expression simplify() throws XPathException {
        this.sequence = this.sequence.simplify();
        return this;
    }

    public Expression analyze(StaticContext staticContext) throws XPathException {
        this.sequence = this.sequence.analyze(staticContext);
        if (Type.isSubType(this.sequence.getItemType(), 90)) {
            return this.sequence;
        }
        return this;
    }

    public Expression promote(PromotionOffer promotionOffer) throws XPathException {
        Expression expression = promotionOffer.accept(this);
        if (expression != null) {
            return expression;
        }
        this.sequence = this.sequence.promote(promotionOffer);
        return this;
    }

    public Expression[] getSubExpressions() {
        Expression[] expressionArray = new Expression[]{this.sequence};
        return expressionArray;
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        SequenceIterator sequenceIterator = this.sequence.iterate(xPathContext);
        return new MappingIterator(sequenceIterator, this, null, null);
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        Item item = this.sequence.evaluateItem(xPathContext);
        if (item == null) {
            return null;
        }
        return (AtomicValue)this.map(item, xPathContext, null);
    }

    public Object map(Item item, XPathContext xPathContext, Object object) throws XPathException {
        AtomicValue atomicValue = item instanceof NodeInfo ? (AtomicValue)item.getTypedValue() : (AtomicValue)item;
        if (atomicValue instanceof UntypedAtomicValue && this.requiredItemType >= 0) {
            return atomicValue.convert(this.requiredItemType);
        }
        return atomicValue;
    }

    public int getItemType() {
        return 90;
    }

    public int computeCardinality() {
        return this.sequence.getCardinality();
    }

    public void display(int n) {
        System.err.println(ExpressionTool.indent(n) + "atomize");
        this.sequence.display(n + 1);
    }
}

