/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.CastExpression;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.MappingFunction;
import net.sf.saxon.expr.MappingIterator;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.Type;
import net.sf.saxon.xpath.XPathException;

public final class AtomicSequenceConverter
extends ComputedExpression
implements MappingFunction {
    private Expression sequence;
    private int requiredItemType;

    public AtomicSequenceConverter(Expression expression, int n) {
        this.sequence = expression;
        this.requiredItemType = n;
    }

    public Expression simplify() throws XPathException {
        this.sequence = this.sequence.simplify();
        return this;
    }

    public Expression analyze(StaticContext staticContext) throws XPathException {
        this.sequence = this.sequence.analyze(staticContext);
        if (Type.isSubType(this.sequence.getItemType(), this.requiredItemType)) {
            return this.sequence;
        }
        if (!Cardinality.allowsMany(this.sequence.getCardinality())) {
            return new CastExpression(this.sequence, this.requiredItemType, (this.sequence.getCardinality() & 0x100) != 0);
        }
        return this;
    }

    public Expression promote(PromotionOffer promotionOffer) throws XPathException {
        this.sequence = this.sequence.promote(promotionOffer);
        return this;
    }

    public Expression[] getSubExpressions() {
        Expression[] expressionArray = new Expression[]{this.sequence};
        return expressionArray;
    }

    public SequenceIterator iterate(XPathContext xPathContext) throws XPathException {
        SequenceIterator sequenceIterator = this.sequence.iterate(xPathContext);
        return new MappingIterator(sequenceIterator, this, null, null);
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        Item item = this.sequence.evaluateItem(xPathContext);
        if (item == null) {
            return null;
        }
        return ((AtomicValue)item).convert(this.requiredItemType);
    }

    public Object map(Item item, XPathContext xPathContext, Object object) throws XPathException {
        return ((AtomicValue)item).convert(this.requiredItemType);
    }

    public int getItemType() {
        return this.requiredItemType;
    }

    public int computeCardinality() {
        return this.sequence.getCardinality();
    }

    public void display(int n) {
        System.err.println(ExpressionTool.indent(n) + "convert items to " + Type.getTypeName(this.requiredItemType));
        this.sequence.display(n + 1);
    }
}

