/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.BinaryExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.Tokenizer;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.CalendarValue;
import net.sf.saxon.value.DurationValue;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Type;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Value;
import net.sf.saxon.xpath.XPathException;

class ArithmeticExpression
extends BinaryExpression {
    private static final int NUMERIC_ARITHMETIC = 0;
    private static final int DATE_AND_DURATION = 1;
    private static final int DATE_DIFFERENCE = 2;
    private static final int DURATION_ADDITION = 3;
    private static final int DURATION_MULTIPLICATION = 4;
    private static final int UNKNOWN = -1;
    private static int[] plusTable = new int[]{91, 91, 0, 91, 91, 125, 0, 91, 125, 91, 0, 91, 125, 125, 0, 91, 109, 106, 1, 109, 106, 109, 1, 109, 108, 106, 1, 108, 106, 108, 1, 108, 107, 106, 1, 107, 106, 107, 1, 107, 240, 240, 3, 240, 241, 241, 3, 241};
    private static int[] minusTable = new int[]{91, 91, 0, 91, 91, 125, 0, 91, 125, 91, 0, 91, 125, 125, 0, 91, 109, 109, 2, 241, 109, 106, 1, 109, 108, 108, 2, 241, 108, 106, 1, 108, 107, 107, 2, 241, 107, 106, 1, 107, 240, 240, 3, 240, 241, 241, 3, 241};
    private static int[] multiplyTable = new int[]{91, 91, 0, 91, 91, 125, 0, 91, 125, 91, 0, 91, 125, 125, 0, 91, 91, 106, 4, 106, 106, 91, 4, 106};
    private static int[] divideTable = new int[]{91, 91, 0, 91, 91, 125, 0, 91, 125, 91, 0, 91, 125, 125, 0, 91, 106, 91, 4, 106};
    private static int[] idivTable = new int[]{91, 91, 0, 200, 91, 125, 0, 200, 125, 91, 0, 200, 125, 125, 0, 200};
    private static int[] modTable = new int[]{91, 91, 0, 91, 91, 125, 0, 91, 125, 91, 0, 91, 125, 125, 0, 91};
    private boolean backwardsCompatible = false;

    public ArithmeticExpression() {
    }

    public ArithmeticExpression(Expression expression, int n, Expression expression2) {
        super(expression, n, expression2);
    }

    public Expression analyze(StaticContext staticContext) throws XPathException {
        Expression expression;
        block11: {
            this.backwardsCompatible = staticContext.isInBackwardsCompatibleMode();
            SequenceType sequenceType = new SequenceType(90, 88, 768);
            RoleLocator roleLocator = new RoleLocator(1, Tokenizer.tokens[this.operator], 0);
            this.operands[0] = TypeChecker.staticTypeCheck(this.operands[0], sequenceType, this.backwardsCompatible, roleLocator);
            RoleLocator roleLocator2 = new RoleLocator(1, Tokenizer.tokens[this.operator], 1);
            this.operands[1] = TypeChecker.staticTypeCheck(this.operands[1], sequenceType, this.backwardsCompatible, roleLocator2);
            expression = super.analyze(staticContext);
            if (!(expression instanceof ArithmeticExpression)) break block11;
            int n = this.operands[0].getItemType();
            int n2 = this.operands[1].getItemType();
            int n3 = this.getAction(n, this.operator, n2);
            switch (n3) {
                case 0: {
                    expression = new NumericArithmetic(this.operands[0], this.operator, this.operands[1]);
                    break;
                }
                case 3: {
                    expression = new DurationAddition(this.operands[0], this.operator, this.operands[1]);
                    break;
                }
                case 4: {
                    expression = new DurationMultiplication(this.operands[0], this.operator, this.operands[1]);
                    break;
                }
                case 1: {
                    expression = new DateAndDuration(this.operands[0], this.operator, this.operands[1]);
                    break;
                }
                case 2: {
                    expression = new DateDifference(this.operands[0], this.operator, this.operands[1]);
                    break;
                }
                default: {
                    if (!this.backwardsCompatible && Type.isSubType(n, 90) && n != 125 && n != 90 && Type.isSubType(n2, 90) && n2 != 125 && n2 != 90) {
                        throw new XPathException.Type("Unsuitable operands for arithmetic operation (" + Type.getTypeName(n) + ", " + Type.getTypeName(n2) + ")");
                    }
                    return expression;
                }
            }
            try {
                if (this.operands[0] instanceof Value && this.operands[1] instanceof Value) {
                    return ExpressionTool.eagerEvaluate(this, null);
                }
            }
            catch (XPathException.Dynamic dynamic) {}
        }
        return expression;
    }

    private int getAction(int n, int n2, int n3) {
        int[] nArray = this.getOperatorTable(n2);
        int n4 = this.getEntry(nArray, n, n3);
        if (n4 < 0) {
            return -1;
        }
        return nArray[n4 + 2];
    }

    private int[] getOperatorTable(int n) {
        switch (n) {
            case 15: {
                return plusTable;
            }
            case 16: 
            case 199: {
                return minusTable;
            }
            case 17: {
                return multiplyTable;
            }
            case 18: {
                return divideTable;
            }
            case 50: {
                return idivTable;
            }
            case 19: {
                return modTable;
            }
        }
        throw new IllegalArgumentException("Unknown arithmetic operator");
    }

    private int getEntry(int[] nArray, int n, int n2) {
        int n3 = 0;
        while (n3 < nArray.length) {
            if (Type.isSubType(n, nArray[n3]) && Type.isSubType(n2, nArray[n3 + 1])) {
                return n3;
            }
            n3 += 4;
        }
        return -1;
    }

    public int getItemType() {
        int n = this.operands[0].getItemType();
        int n2 = this.operands[1].getItemType();
        int[] nArray = this.getOperatorTable(this.operator);
        int n3 = this.getEntry(nArray, n, n2);
        if (n3 < 0) {
            return 90;
        }
        int n4 = nArray[n3 + 3];
        if (n4 == 91) {
            n4 = NumericValue.promote(n, n2);
            if (this.operator == 18 && n4 == 200) {
                n4 = 103;
            }
        }
        return n4;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        AtomicValue atomicValue = (AtomicValue)this.operands[0].evaluateItem(xPathContext);
        if (atomicValue == null) {
            return null;
        }
        AtomicValue atomicValue2 = (AtomicValue)this.operands[1].evaluateItem(xPathContext);
        if (atomicValue2 == null) {
            return null;
        }
        int n = this.getAction(atomicValue.getItemType(), this.operator, atomicValue2.getItemType());
        switch (n) {
            case 0: {
                return new NumericArithmetic(atomicValue, this.operator, atomicValue2).evaluateItem(xPathContext);
            }
            case 3: {
                return new DurationAddition(atomicValue, this.operator, atomicValue2).evaluateItem(xPathContext);
            }
            case 4: {
                return new DurationMultiplication(atomicValue, this.operator, atomicValue2).evaluateItem(xPathContext);
            }
            case 1: {
                return new DateAndDuration(atomicValue, this.operator, atomicValue2).evaluateItem(xPathContext);
            }
            case 2: {
                return new DateDifference(atomicValue, this.operator, atomicValue2).evaluateItem(xPathContext);
            }
        }
        if (this.backwardsCompatible) {
            NumericValue numericValue;
            NumericValue numericValue2;
            try {
                numericValue2 = (NumericValue)atomicValue.convert(91);
                numericValue = (NumericValue)atomicValue2.convert(91);
            }
            catch (XPathException xPathException) {
                this.typeError("Unsuitable operands for arithmetic operation (" + Type.getTypeName(atomicValue.getItemType()) + ", " + Type.getTypeName(atomicValue2.getItemType()) + ")");
                return null;
            }
            return new NumericArithmetic(numericValue2, this.operator, numericValue).evaluateItem(xPathContext);
        }
        this.typeError("Unsuitable operands for arithmetic operation (" + Type.getTypeName(atomicValue.getItemType()) + ", " + Type.getTypeName(atomicValue2.getItemType()) + ")");
        return null;
    }

    public static class DateDifference
    extends ArithmeticExpression {
        public DateDifference(Expression expression, int n, Expression expression2) {
            super(expression, n, expression2);
        }

        public Item evaluateItem(XPathContext xPathContext) throws XPathException {
            CalendarValue calendarValue = (CalendarValue)this.operands[0].evaluateItem(xPathContext);
            if (calendarValue == null) {
                return null;
            }
            CalendarValue calendarValue2 = (CalendarValue)this.operands[1].evaluateItem(xPathContext);
            if (calendarValue2 == null) {
                return null;
            }
            return calendarValue.subtract(calendarValue2);
        }
    }

    public static class DateAndDuration
    extends ArithmeticExpression {
        public DateAndDuration(Expression expression, int n, Expression expression2) {
            super(expression, n, expression2);
            if (Type.isSubType(expression.getItemType(), 106)) {
                this.operands[0] = expression2;
                this.operands[1] = expression;
            }
        }

        public Item evaluateItem(XPathContext xPathContext) throws XPathException {
            CalendarValue calendarValue = (CalendarValue)this.operands[0].evaluateItem(xPathContext);
            if (calendarValue == null) {
                return null;
            }
            DurationValue durationValue = (DurationValue)this.operands[1].evaluateItem(xPathContext);
            if (durationValue == null) {
                return null;
            }
            if (this.operator == 16) {
                durationValue = durationValue.multiply(-1.0);
            }
            return calendarValue.add(durationValue);
        }
    }

    public static class DurationMultiplication
    extends ArithmeticExpression {
        public DurationMultiplication(Expression expression, int n, Expression expression2) {
            super(expression, n, expression2);
            if (Type.isSubType(expression2.getItemType(), 106)) {
                this.operands[0] = expression2;
                this.operands[1] = expression;
            }
        }

        public Item evaluateItem(XPathContext xPathContext) throws XPathException {
            DurationValue durationValue = (DurationValue)this.operands[0].evaluateItem(xPathContext);
            if (durationValue == null) {
                return null;
            }
            NumericValue numericValue = (NumericValue)this.operands[1].evaluateItem(xPathContext);
            double d = numericValue.asDouble();
            if (this.operator == 18) {
                d = 1.0 / d;
            }
            return durationValue.multiply(d);
        }
    }

    public static class DurationAddition
    extends ArithmeticExpression {
        public DurationAddition(Expression expression, int n, Expression expression2) {
            super(expression, n, expression2);
        }

        public Item evaluateItem(XPathContext xPathContext) throws XPathException {
            DurationValue durationValue = (DurationValue)this.operands[0].evaluateItem(xPathContext);
            if (durationValue == null) {
                return null;
            }
            DurationValue durationValue2 = (DurationValue)this.operands[1].evaluateItem(xPathContext);
            if (durationValue2 == null) {
                return null;
            }
            if (this.operator == 15) {
                return durationValue.add(durationValue2);
            }
            if (this.operator == 16) {
                return durationValue.subtract(durationValue2);
            }
            throw new AssertionError((Object)"Unknown operation on durations");
        }
    }

    public static class NumericArithmetic
    extends ArithmeticExpression {
        public NumericArithmetic(Expression expression, int n, Expression expression2) {
            super(expression, n, expression2);
        }

        public Item evaluateItem(XPathContext xPathContext) throws XPathException {
            AtomicValue atomicValue;
            int n;
            AtomicValue atomicValue2 = (AtomicValue)this.operands[0].evaluateItem(xPathContext);
            int n2 = n = this.operator == 50 ? 200 : 105;
            if (atomicValue2 == null) {
                return null;
            }
            if (atomicValue2 instanceof UntypedAtomicValue) {
                atomicValue2 = atomicValue2.convert(n);
            }
            if ((atomicValue = (AtomicValue)this.operands[1].evaluateItem(xPathContext)) == null) {
                return null;
            }
            if (atomicValue instanceof UntypedAtomicValue) {
                atomicValue = atomicValue.convert(n);
            }
            if (this.operator == 199) {
                return ((NumericValue)atomicValue).negate();
            }
            if (this.operator == 50) {
                if (!(atomicValue2 instanceof IntegerValue)) {
                    this.typeError("First argument to idiv must be an integer");
                    return null;
                }
                if (!(atomicValue instanceof IntegerValue)) {
                    this.typeError("Second argument to idiv must be an integer");
                    return null;
                }
            }
            return ((NumericValue)atomicValue2).arithmetic(this.operator, (NumericValue)atomicValue);
        }
    }
}

