/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import javax.xml.transform.TransformerException;
import net.sf.saxon.event.CDATAFilter;
import net.sf.saxon.event.Emitter;
import net.sf.saxon.event.HTMLEmitter;
import net.sf.saxon.event.HTMLIndenter;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.XHTMLEmitter;
import net.sf.saxon.event.XMLEmitter;
import net.sf.saxon.event.XMLIndenter;

public class UncommittedEmitter
extends Emitter {
    boolean committed = false;
    boolean initialNewline = false;
    Receiver baseReceiver = null;
    StringBuffer pendingCharacters;

    public void startDocument() throws TransformerException {
        this.committed = false;
    }

    public void endDocument() throws TransformerException {
        if (!this.committed) {
            this.switchToXML();
        }
        this.baseReceiver.endDocument();
    }

    public void characters(CharSequence charSequence, int n) throws TransformerException {
        if (!this.committed) {
            boolean bl = true;
            if (this.pendingCharacters == null) {
                this.pendingCharacters = new StringBuffer();
            }
            int n2 = 0;
            while (n2 < charSequence.length()) {
                char c = charSequence.charAt(n2);
                if (!Character.isWhitespace(c)) {
                    bl = false;
                }
                if ((n & 1) == 0) {
                    if (c == '<') {
                        this.pendingCharacters.append("&lt;");
                    } else if (c == '>') {
                        this.pendingCharacters.append("&gt;");
                    } else if (c == '&') {
                        this.pendingCharacters.append("&amp;");
                    } else {
                        this.pendingCharacters.append(c);
                    }
                } else {
                    this.pendingCharacters.append(c);
                }
                ++n2;
            }
            if (!bl) {
                this.switchToXML();
            }
        } else {
            this.baseReceiver.characters(charSequence, n);
        }
    }

    public void processingInstruction(String string, CharSequence charSequence, int n) throws TransformerException {
        if (!this.committed) {
            if (this.pendingCharacters == null) {
                this.pendingCharacters = new StringBuffer();
            }
            this.pendingCharacters.append("<?" + string + " " + charSequence.toString() + "?>");
        } else {
            this.baseReceiver.processingInstruction(string, charSequence, n);
        }
    }

    public void comment(CharSequence charSequence, int n) throws TransformerException {
        if (!this.committed) {
            if (this.pendingCharacters == null) {
                this.pendingCharacters = new StringBuffer();
            }
            this.pendingCharacters.append("<!--" + charSequence.toString() + "-->");
        } else {
            this.baseReceiver.comment(charSequence, n);
        }
    }

    public void startElement(int n, int n2, int n3) throws TransformerException {
        if (!this.committed) {
            String string = this.namePool.getLocalName(n);
            short s = this.namePool.getURICode(n);
            if (string.equalsIgnoreCase("html") && s == 0) {
                this.switchToHTML();
            } else if (string.equals("html") && this.namePool.getURIFromURICode(s) == "http://www.w3.org/1999/xhtml") {
                this.switchToXHTML();
            } else {
                this.switchToXML();
            }
        }
        this.baseReceiver.startElement(n, n2, n3);
    }

    public void namespace(int n, int n2) throws TransformerException {
        this.baseReceiver.namespace(n, n2);
    }

    public void attribute(int n, int n2, String string, int n3) throws TransformerException {
        this.baseReceiver.attribute(n, n2, string, n3);
    }

    public void startContent() throws TransformerException {
        this.baseReceiver.startContent();
    }

    public void endElement() throws TransformerException {
        this.baseReceiver.endElement();
    }

    private void switchToXML() throws TransformerException {
        Object object;
        XMLEmitter xMLEmitter = new XMLEmitter();
        this.baseReceiver = xMLEmitter;
        String string = this.outputProperties.getProperty("indent");
        if (string != null && string.equals("yes")) {
            object = new XMLIndenter();
            ((ProxyReceiver)object).setUnderlyingReceiver(xMLEmitter);
            ((ProxyReceiver)object).setNamePool(this.namePool);
            ((XMLIndenter)object).setOutputProperties(this.outputProperties);
            this.baseReceiver = object;
        }
        if ((object = this.outputProperties.getProperty("cdata-section-elements")) != null && ((String)object).length() > 0) {
            CDATAFilter cDATAFilter = new CDATAFilter();
            cDATAFilter.setUnderlyingReceiver(xMLEmitter);
            cDATAFilter.setNamePool(this.namePool);
            cDATAFilter.setOutputProperties(this.outputProperties);
            this.baseReceiver = cDATAFilter;
        }
        this.switchTo(xMLEmitter);
    }

    private void switchToXHTML() throws TransformerException {
        XHTMLEmitter xHTMLEmitter = new XHTMLEmitter();
        this.baseReceiver = xHTMLEmitter;
        String string = this.outputProperties.getProperty("indent");
        if (string == null || string.equals("yes")) {
            XMLIndenter xMLIndenter = new XMLIndenter();
            xMLIndenter.setUnderlyingReceiver(xHTMLEmitter);
            xMLIndenter.setNamePool(this.namePool);
            xMLIndenter.setOutputProperties(this.outputProperties);
            this.baseReceiver = xMLIndenter;
        }
        this.switchTo(xHTMLEmitter);
    }

    private void switchToHTML() throws TransformerException {
        HTMLEmitter hTMLEmitter = new HTMLEmitter();
        this.baseReceiver = hTMLEmitter;
        String string = this.outputProperties.getProperty("indent");
        if (string == null || string.equals("yes")) {
            HTMLIndenter hTMLIndenter = new HTMLIndenter();
            hTMLIndenter.setUnderlyingReceiver(hTMLEmitter);
            hTMLIndenter.setNamePool(this.namePool);
            hTMLIndenter.setOutputProperties(this.outputProperties);
            this.baseReceiver = hTMLIndenter;
        }
        this.switchTo(hTMLEmitter);
    }

    private void switchTo(Emitter emitter) throws TransformerException {
        this.committed = true;
        emitter.setWriter(this.writer);
        emitter.characterSet = this.characterSet;
        emitter.setOutputProperties(this.outputProperties);
        emitter.setNamePool(this.namePool);
        this.baseReceiver.startDocument();
        if (this.pendingCharacters != null) {
            emitter.characters(this.pendingCharacters, 1);
        }
    }
}

