/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import javax.xml.transform.TransformerException;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Type;
import net.sf.saxon.value.UntypedAtomicValue;

public class SequenceChecker
extends ProxyReceiver
implements SequenceReceiver {
    private int itemType;
    private int contentType;
    private int cardinality;
    private int count = 0;
    private int level = 0;
    private boolean atomize = false;
    private StringBuffer buffer = null;

    public void setRequiredType(SequenceType sequenceType) {
        this.itemType = sequenceType.getPrimaryType();
        this.contentType = sequenceType.getContentType();
        this.cardinality = sequenceType.getCardinality();
        this.atomize = Type.isSubType(this.itemType, 90);
    }

    public void startElement(int n, int n2, int n3) throws TransformerException {
        if (this.level++ == 0) {
            if (this.atomize) {
                this.buffer = new StringBuffer();
                return;
            }
            if (this.count++ == 1 && !Cardinality.allowsMany(this.cardinality)) {
                throw new TransformerException("The output sequence contains more than one item, only one is allowed");
            }
            if (this.itemType != 88 && this.itemType != 0 && this.itemType != 1) {
                throw new TransformerException("The output sequence is not allowed to contain elements");
            }
            if (this.contentType != 88 && !Type.isSubType(n2, this.contentType)) {
                throw new TransformerException("The required content type for items in the output sequence is " + Type.getTypeName(this.contentType));
            }
        }
        super.startElement(n, n2, n3);
    }

    public void namespace(int n, int n2) throws TransformerException {
        if (this.level == 0) {
            if (this.atomize) {
                return;
            }
            if (this.count++ == 1 && !Cardinality.allowsMany(this.cardinality)) {
                throw new TransformerException("The output sequence contains more than one item, only one is allowed");
            }
            if (this.itemType != 88 && this.itemType != 0 && this.itemType != 13) {
                throw new TransformerException("The output sequence is not allowed to contain namespace nodes");
            }
        } else if (this.buffer != null) {
            return;
        }
        super.namespace(n, n2);
    }

    public void attribute(int n, int n2, String string, int n3) throws TransformerException {
        if (this.level == 0) {
            if (this.atomize) {
                if (n2 == 0) {
                    this.append(new UntypedAtomicValue(string));
                } else {
                    this.append(new StringValue(string).convert(n2));
                }
                return;
            }
            if (this.count++ == 1 && !Cardinality.allowsMany(this.cardinality)) {
                throw new TransformerException("The output sequence contains more than one item, only one is allowed");
            }
            if (this.itemType != 88 && this.itemType != 0 && this.itemType != 2) {
                throw new TransformerException("The output sequence is not allowed to contain attribute nodes");
            }
            if (this.contentType != 88 && !Type.isSubType(n2, this.contentType)) {
                throw new TransformerException("The required content type for items in the output sequence is " + Type.getTypeName(this.contentType));
            }
        } else if (this.buffer != null) {
            return;
        }
        super.attribute(n, n2, string, n3);
    }

    public void endElement() throws TransformerException {
        --this.level;
        if (this.buffer != null) {
            if (this.level == 0) {
                this.append(new UntypedAtomicValue(this.buffer));
                this.buffer = null;
                return;
            }
            return;
        }
        super.endElement();
    }

    public void characters(CharSequence charSequence, int n) throws TransformerException {
        if (this.level == 0) {
            if (this.atomize) {
                this.append(new UntypedAtomicValue(charSequence));
                return;
            }
            if (this.count++ == 1 && !Cardinality.allowsMany(this.cardinality)) {
                throw new TransformerException("The output sequence contains more than one item, only one is allowed");
            }
            if (this.itemType != 88 && this.itemType != 0 && this.itemType != 3) {
                throw new TransformerException("The output sequence is not allowed to contain text nodes");
            }
        } else if (this.buffer != null) {
            this.buffer.append((Object)charSequence);
            return;
        }
        super.characters(charSequence, n);
    }

    public void processingInstruction(String string, CharSequence charSequence, int n) throws TransformerException {
        if (this.level == 0) {
            if (this.atomize) {
                this.append(new UntypedAtomicValue(charSequence));
                return;
            }
            if (this.count++ == 1 && !Cardinality.allowsMany(this.cardinality)) {
                throw new TransformerException("The output sequence contains more than one item, only one is allowed");
            }
            if (this.itemType != 88 && this.itemType != 0 && this.itemType != 7) {
                throw new TransformerException("The output sequence is not allowed to contain processing instruction nodes");
            }
        } else if (this.buffer != null) {
            return;
        }
        super.processingInstruction(string, charSequence, n);
    }

    public void comment(CharSequence charSequence, int n) throws TransformerException {
        if (this.level == 0) {
            if (this.atomize) {
                this.append(new UntypedAtomicValue(charSequence));
                return;
            }
            if (this.count++ == 1 && !Cardinality.allowsMany(this.cardinality)) {
                throw new TransformerException("The output sequence contains more than one item, only one is allowed");
            }
            if (this.itemType != 88 && this.itemType != 0 && this.itemType != 8) {
                throw new TransformerException("The output sequence is not allowed to contain comment nodes");
            }
        } else if (this.buffer != null) {
            return;
        }
        super.comment(charSequence, n);
    }

    public void append(Item item) throws TransformerException {
        if (this.level == 0) {
            if (this.atomize && item instanceof NodeInfo) {
                SequenceIterator sequenceIterator = item.getTypedValue().iterate(null);
                while (sequenceIterator.hasNext()) {
                    this.append(sequenceIterator.next());
                }
                return;
            }
            if (this.count == 1 && !Cardinality.allowsMany(this.cardinality)) {
                throw new TransformerException("The output sequence contains more than one item, only one is allowed");
            }
            int n = item.getItemType();
            if (n == 125 && this.itemType != 125) {
                this.append(((AtomicValue)item).convert(this.itemType));
                return;
            }
            if (!Type.isSubType(n, this.itemType)) {
                throw new TransformerException("The output sequence is not allowed to contain items of type " + Type.getTypeName(item.getItemType()));
            }
        }
        ((SequenceReceiver)this.baseReceiver).append(item);
        ++this.count;
    }

    public void finalCheck() throws TransformerException {
        if (this.count == 0 && (this.cardinality & 0x100) == 0) {
            throw new TransformerException("The output sequence is not allowed to be empty");
        }
        super.endDocument();
    }
}

