/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import javax.xml.transform.TransformerException;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.NodeInfo;
import org.xml.sax.Locator;

public class DocumentSender
implements Locator {
    private NodeInfo top;

    public DocumentSender(NodeInfo nodeInfo) {
        this.top = nodeInfo;
        int n = nodeInfo.getItemType();
        if (n != 9 && n != 1) {
            throw new IllegalArgumentException("DocumentSender can only handle document or element nodes");
        }
    }

    public void send(Receiver receiver) throws TransformerException {
        if (this.top.getNamePool() != receiver.getNamePool()) {
            throw new IllegalArgumentException("DocumentSender source and target must use the same NamePool");
        }
        receiver.setSystemId(this.top.getSystemId());
        receiver.setDocumentLocator(this);
        receiver.startDocument();
        this.top.copy(receiver, 2, true);
        receiver.endDocument();
    }

    public int getColumnNumber() {
        return -1;
    }

    public int getLineNumber() {
        return -1;
    }

    public String getPublicId() {
        return null;
    }

    public String getSystemId() {
        return this.top.getSystemId();
    }
}

