/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.util.Date;
import javax.xml.transform.TransformerException;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.tinytree.TinyDocumentImpl;
import org.xml.sax.Locator;

public abstract class Builder
implements Receiver {
    public static final int STANDARD_TREE = 0;
    public static final int TINY_TREE = 1;
    protected NamePool namePool;
    protected String systemId;
    protected Locator locator;
    protected DocumentInfo currentDocument;
    protected boolean started = false;
    protected boolean timing = false;
    protected boolean lineNumbering = false;
    private long startTime;

    public void setNamePool(NamePool namePool) {
        this.namePool = namePool;
    }

    public NamePool getNamePool() {
        return this.namePool;
    }

    public void setSystemId(String string) {
        this.systemId = string;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void setRootNode(DocumentInfo documentInfo) {
        this.currentDocument = documentInfo;
    }

    public void setTiming(boolean bl) {
        this.timing = bl;
    }

    public boolean isTiming() {
        return this.timing;
    }

    public void setLineNumbering(boolean bl) {
        this.lineNumbering = bl;
    }

    public void startDocument() throws TransformerException {
        if (this.timing) {
            System.err.println("Building tree for " + this.getSystemId() + " using " + this.getClass());
            this.startTime = new Date().getTime();
        }
    }

    public void endDocument() throws TransformerException {
        if (this.timing) {
            long l = new Date().getTime();
            System.err.println("Tree built in " + (l - this.startTime) + " milliseconds");
            if (this.currentDocument instanceof TinyDocumentImpl) {
                ((TinyDocumentImpl)this.currentDocument).showSize();
            }
            this.startTime = l;
        }
    }

    public DocumentInfo getCurrentDocument() {
        return this.currentDocument;
    }
}

