/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon;

import java.io.Serializable;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.URIResolver;
import net.sf.saxon.Loader;
import net.sf.saxon.OutputURIResolver;
import net.sf.saxon.StandardErrorListener;
import net.sf.saxon.StandardURIResolver;
import net.sf.saxon.event.StandardOutputResolver;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.trace.TraceListener;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class Configuration
implements Serializable {
    private transient URIResolver resolver;
    private transient ErrorListener listener;
    private int treeModel = 1;
    private boolean lineNumbering = false;
    private TraceListener traceListener = null;
    private int recoveryPolicy = 1;
    private String messageEmitterClass = "net.sf.saxon.event.MessageEmitter";
    private String sourceParserClass;
    private String styleParserClass;
    private transient OutputURIResolver outputURIResolver;
    private boolean timing = false;
    private boolean allowExternalFunctions = true;
    private boolean traceExternalFunctions = false;
    private boolean validation = false;
    private NamePool targetNamePool = null;
    private boolean stripsAllWhiteSpace = false;
    private int hostLanguage = 10;
    public static final int RECOVER_SILENTLY = 0;
    public static final int RECOVER_WITH_WARNINGS = 1;
    public static final int DO_NOT_RECOVER = 2;
    public static final int XSLT = 10;
    public static final int XQUERY = 11;

    public int getHostLanguage() {
        return this.hostLanguage;
    }

    public void setHostLanguage(int n) {
        this.hostLanguage = n;
    }

    public URIResolver getURIResolver() {
        if (this.resolver == null) {
            this.resolver = new StandardURIResolver(this);
        }
        return this.resolver;
    }

    public void setURIResolver(URIResolver uRIResolver) {
        this.resolver = uRIResolver;
    }

    public ErrorListener getErrorListener() {
        if (this.listener == null) {
            this.listener = new StandardErrorListener();
        }
        return this.listener;
    }

    public void setErrorListener(ErrorListener errorListener) {
        this.listener = errorListener;
    }

    public int getTreeModel() {
        return this.treeModel;
    }

    public void setTreeModel(int n) {
        this.treeModel = n;
    }

    public boolean isLineNumbering() {
        return this.lineNumbering;
    }

    public void setLineNumbering(boolean bl) {
        this.lineNumbering = bl;
    }

    public TraceListener getTraceListener() {
        return this.traceListener;
    }

    public void setTraceListener(TraceListener traceListener) {
        this.traceListener = traceListener;
    }

    public int getRecoveryPolicy() {
        return this.recoveryPolicy;
    }

    public void setRecoveryPolicy(int n) {
        this.recoveryPolicy = n;
    }

    public String getMessageEmitterClass() {
        return this.messageEmitterClass;
    }

    public void setMessageEmitterClass(String string) {
        this.messageEmitterClass = string;
    }

    public String getSourceParserClass() {
        return this.sourceParserClass;
    }

    public void setSourceParserClass(String string) {
        this.sourceParserClass = string;
    }

    public String getStyleParserClass() {
        return this.styleParserClass;
    }

    public void setStyleParserClass(String string) {
        this.styleParserClass = string;
    }

    public OutputURIResolver getOutputURIResolver() {
        if (this.outputURIResolver == null) {
            this.outputURIResolver = StandardOutputResolver.getInstance();
        }
        return this.outputURIResolver;
    }

    public void setOutputURIResolver(OutputURIResolver outputURIResolver) {
        this.outputURIResolver = outputURIResolver;
    }

    public boolean isTiming() {
        return this.timing;
    }

    public void setTiming(boolean bl) {
        this.timing = bl;
    }

    public boolean isAllowExternalFunctions() {
        return this.allowExternalFunctions;
    }

    public void setAllowExternalFunctions(boolean bl) {
        this.allowExternalFunctions = bl;
    }

    public boolean isTraceExternalFunctions() {
        return this.traceExternalFunctions;
    }

    public void setTraceExternalFunctions(boolean bl) {
        this.traceExternalFunctions = bl;
    }

    public boolean isValidation() {
        return this.validation;
    }

    public void setValidation(boolean bl) {
        this.validation = bl;
    }

    public NamePool getTargetNamePool() {
        return this.targetNamePool;
    }

    public void setTargetNamePool(NamePool namePool) {
        this.targetNamePool = namePool;
    }

    public boolean isStripsAllWhiteSpace() {
        return this.stripsAllWhiteSpace;
    }

    public void setStripsAllWhiteSpace(boolean bl) {
        this.stripsAllWhiteSpace = bl;
    }

    public XMLReader getSourceParser() throws TransformerFactoryConfigurationError {
        XMLReader xMLReader;
        if (this.getSourceParserClass() != null) {
            XMLReader xMLReader2 = Configuration.makeParser(this.getSourceParserClass());
            return xMLReader2;
        }
        try {
            xMLReader = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
        }
        catch (Exception exception) {
            throw new TransformerFactoryConfigurationError(exception);
        }
        if (this.isValidation()) {
            try {
                xMLReader.setFeature("http://xml.org/sax/features/validation", true);
            }
            catch (SAXException sAXException) {
                throw new TransformerFactoryConfigurationError("The XML parser does not support validation");
            }
        }
        return xMLReader;
    }

    public XMLReader getStyleParser() throws TransformerFactoryConfigurationError {
        if (this.getStyleParserClass() != null) {
            return Configuration.makeParser(this.getStyleParserClass());
        }
        try {
            return SAXParserFactory.newInstance().newSAXParser().getXMLReader();
        }
        catch (Exception exception) {
            throw new TransformerFactoryConfigurationError(exception);
        }
    }

    public static XMLReader makeParser(String string) throws TransformerFactoryConfigurationError {
        Object object;
        try {
            object = Loader.getInstance(string);
        }
        catch (TransformerException transformerException) {
            throw new TransformerFactoryConfigurationError(transformerException);
        }
        if (object instanceof XMLReader) {
            return (XMLReader)object;
        }
        throw new TransformerFactoryConfigurationError("Class " + string + " is not a SAX2 XMLReader");
    }
}

