<?xml version="1.0" encoding="utf-8"?>

<!--
 * Copyright (c) 2002 World Wide Web Consortium,
 * (Massachusetts Institute of Technology, Institut National de
 * Recherche en Informatique et en Automatique, Keio University). All
 * Rights Reserved. This program is distributed under the W3C's Software
 * Intellectual Property License. This program is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.
 * See W3C License http://www.w3.org/Consortium/Legal/ for more details.
-->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  version="1.0" xmlns:g="http://www.w3.org/2001/03/XPath/grammar">
  <xsl:param name="spec1" select="'xpath'"/>
  <xsl:param name="not-subspec" select="'xslt-patterns'"/>
  
  <xsl:template match="@*|node()">
    <xsl:choose>
      <xsl:when test="$spec1='shared'">
        <xsl:if test="self::node()[not(@if) 
                      or contains(@if, 'xpath') 
                      or contains(@if, 'xquery')]
                      [not(@sub-spec=$not-subspec)]">
          <xsl:copy>
            <xsl:apply-templates select="@*|node()"/>
          </xsl:copy>        
        </xsl:if>
      </xsl:when>
      <xsl:otherwise>
        <xsl:variable name="s1" select="normalize-space($spec1)"/>
        <xsl:variable name="s2">
          <xsl:choose>
            <xsl:when test="$s1 = 'xpath'">
              <xsl:text>not-xquery</xsl:text>
            </xsl:when>
            <xsl:when test="$s1 = 'xquery'">
              <xsl:text>not-xpath</xsl:text>
            </xsl:when>
            <xsl:when test="$s1 = 'pathx1'">
              <xsl:text>xpath</xsl:text>
            </xsl:when>
          </xsl:choose>
        </xsl:variable>
        
        <xsl:if test="self::node()[not(@if) or contains(@if, $s1) or contains(@if, $s2)]
                      [not(@sub-spec=$not-subspec)]">
          <xsl:if test="not(self::g:level) or self::g:level
                        [not(@if) or (contains(@if, $s1) or contains(@if, $s2))]
                        [*[not(@if) or (contains(@if, $s1) or contains(@if, $s2))]]">
            <xsl:copy>
              <xsl:apply-templates select="@*|node()"/>
            </xsl:copy>        
          </xsl:if>
        </xsl:if>
      </xsl:otherwise>
    </xsl:choose>
    
  </xsl:template>

</xsl:stylesheet>
