/*
 * Decompiled with CFR 0.152.
 */
import java.io.PrintStream;

public class SimpleNode
implements Node {
    protected Node parent;
    protected Node[] children;
    protected int id;
    protected XPath parser;
    protected String m_value;

    public SimpleNode(int n) {
        this.id = n;
    }

    public SimpleNode(XPath xPath, int n) {
        this(n);
        this.parser = xPath;
    }

    public void jjtOpen() {
    }

    public void jjtClose() {
    }

    public void jjtSetParent(Node node) {
        this.parent = node;
    }

    public Node jjtGetParent() {
        return this.parent;
    }

    public void jjtAddChild(Node node, int n) {
        if (this.children == null) {
            this.children = new Node[n + 1];
        } else if (n >= this.children.length) {
            Node[] nodeArray = new Node[n + 1];
            System.arraycopy(this.children, 0, nodeArray, 0, this.children.length);
            this.children = nodeArray;
        }
        this.children[n] = node;
    }

    public Node jjtGetChild(int n) {
        return this.children[n];
    }

    public int jjtGetNumChildren() {
        return this.children == null ? 0 : this.children.length;
    }

    public Object jjtAccept(XPathVisitor xPathVisitor, Object object) {
        return xPathVisitor.visit(this, object);
    }

    public Object childrenAccept(XPathVisitor xPathVisitor, Object object) {
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                this.children[i].jjtAccept(xPathVisitor, object);
            }
        }
        return object;
    }

    public String toString() {
        return XPathTreeConstants.jjtNodeName[this.id];
    }

    public String toString(String string) {
        return string + this.toString();
    }

    public void dump(String string) {
        this.dump(string, System.out);
    }

    public void dump(String string, PrintStream printStream) {
        printStream.print(this.toString(string));
        this.printValue(printStream);
        printStream.println();
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                SimpleNode simpleNode = (SimpleNode)this.children[i];
                if (simpleNode == null) continue;
                simpleNode.dump(string + "   ", printStream);
            }
        }
    }

    public void processToken(Token token) {
        this.m_value = token.image;
    }

    public void printValue(PrintStream printStream) {
        if (null != this.m_value) {
            printStream.print(" " + this.m_value);
        }
    }
}

