/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.xpath;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.sort.FixedSortKeyDefinition;
import net.sf.saxon.sort.SortedIterator;
import net.sf.saxon.value.Type;
import net.sf.saxon.xpath.XPathEvaluator;
import net.sf.saxon.xpath.XPathException;

public final class XPathExpression {
    private DocumentInfo boundDocument;
    private Expression expression;
    private NodeInfo contextNode;
    private XPathExpression sortKey = null;

    protected XPathExpression(Expression expression, DocumentInfo documentInfo) {
        this.expression = expression;
        this.boundDocument = documentInfo;
        this.contextNode = documentInfo;
    }

    public void setSortKey(XPathExpression xPathExpression) {
        this.sortKey = xPathExpression;
    }

    public void setContextNode(NodeInfo nodeInfo) {
        if (nodeInfo == null) {
            throw new NullPointerException("Context node cannot be null");
        }
        if (nodeInfo.getDocumentRoot() != this.boundDocument) {
            throw new IllegalArgumentException("Supplied node is in wrong document");
        }
        this.contextNode = nodeInfo;
    }

    public List evaluate() throws XPathException {
        SequenceIterator sequenceIterator = this.rawIterator();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while (sequenceIterator.hasNext()) {
            Item item = sequenceIterator.next();
            arrayList.add(XPathEvaluator.convert(item));
        }
        return arrayList;
    }

    public Object evaluateSingle() throws XPathException {
        XPathContext xPathContext = new XPathContext(this.contextNode);
        xPathContext.setLocalVariableFrame(new Object[50]);
        SequenceIterator sequenceIterator = this.expression.iterate(xPathContext);
        if (sequenceIterator.hasNext()) {
            return XPathEvaluator.convert(sequenceIterator.next());
        }
        return null;
    }

    public SequenceIterator rawIterator() throws XPathException {
        XPathContext xPathContext = new XPathContext(this.contextNode);
        xPathContext.setLocalVariableFrame(new Object[50]);
        SequenceIterator sequenceIterator = this.expression.iterate(xPathContext);
        if (this.sortKey != null) {
            Expression expression = this.sortKey.expression;
            if (Type.isSubType(expression.getItemType(), 0)) {
                expression = new Atomizer(expression);
            }
            FixedSortKeyDefinition[] fixedSortKeyDefinitionArray = new FixedSortKeyDefinition[]{new FixedSortKeyDefinition()};
            fixedSortKeyDefinitionArray[0].setSortKey(expression);
            fixedSortKeyDefinitionArray[0].simplify();
            sequenceIterator = new SortedIterator(xPathContext, sequenceIterator, fixedSortKeyDefinitionArray);
        }
        return sequenceIterator;
    }
}

