/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.xpath;

import java.util.Comparator;
import java.util.HashMap;
import javax.xml.transform.TransformerException;
import net.sf.saxon.expr.CastExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FunctionCall;
import net.sf.saxon.expr.FunctionProxy;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.VariableDeclaration;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.functions.XSLTFunction;
import net.sf.saxon.instruct.FunctionSignature;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.Name;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.sort.CodepointCollator;
import net.sf.saxon.sort.CollationFactory;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Type;
import net.sf.saxon.xpath.Variable;
import net.sf.saxon.xpath.XPathException;

public class StandaloneContext
implements StaticContext {
    private NamePool namePool;
    private HashMap namespaces = new HashMap();
    private HashMap collations = new HashMap();
    private HashMap variables = new HashMap();
    private String defaultCollationName = null;

    public StandaloneContext() {
        this(NamePool.getDefaultNamePool());
    }

    public StandaloneContext(NamePool namePool) {
        this.namePool = namePool;
        this.clearNamespaces();
    }

    public StandaloneContext(NodeInfo nodeInfo) {
        DocumentInfo documentInfo = nodeInfo.getDocumentRoot();
        if (documentInfo == null) {
            throw new IllegalArgumentException("The node used to establish a standalone context must be in a tree whose root is a document node");
        }
        this.namePool = documentInfo.getNamePool();
        this.setNamespaces(nodeInfo);
    }

    public void declareNamespace(String string, String string2) {
        if (string == null) {
            throw new NullPointerException("Null prefix supplied to declareNamespace()");
        }
        if (string2 == null) {
            throw new NullPointerException("Null namespace URI supplied to declareNamespace()");
        }
        this.namespaces.put(string, string2);
        this.namePool.allocateNamespaceCode(string, string2);
    }

    public void clearNamespaces() {
        this.namespaces.clear();
        this.declareNamespace("xml", "http://www.w3.org/XML/1998/namespace");
        this.declareNamespace("xsl", "http://www.w3.org/1999/XSL/Transform");
        this.declareNamespace("saxon", "http://saxon.sf.net/");
        this.declareNamespace("xs", "http://www.w3.org/2001/XMLSchema");
        this.declareNamespace("", "");
    }

    public void setNamespaces(NodeInfo nodeInfo) {
        this.namespaces.clear();
        AxisIterator axisIterator = nodeInfo.iterateAxis((byte)8);
        while (axisIterator.hasNext()) {
            NodeInfo nodeInfo2 = (NodeInfo)axisIterator.next();
            this.declareNamespace(nodeInfo2.getLocalName(), nodeInfo2.getStringValue());
        }
    }

    public void declareCollation(String string, Comparator comparator, boolean bl) {
        this.collations.put(string, comparator);
        if (bl) {
            this.defaultCollationName = string;
        }
    }

    public Variable declareVariable(String string, Object object) throws XPathException {
        String string2;
        String string3;
        Object object2;
        try {
            object2 = Name.getQNameParts(string);
            string3 = object2[0];
            string2 = object2[1];
        }
        catch (QNameException qNameException) {
            throw new XPathException.Static("Invalid QName for variable: " + string);
        }
        object2 = "";
        if (!"".equals(string3)) {
            object2 = this.getURIForPrefix(string3);
        }
        Variable variable = Variable.make(string);
        variable.setValue(object);
        int n = this.namePool.allocate(string3, (String)object2, string2) & 0xFFFFF;
        this.variables.put(new Integer(n), variable);
        return variable;
    }

    public NamePool getNamePool() {
        return this.namePool;
    }

    public void issueWarning(String string) {
        System.err.println(string);
    }

    public String getSystemId() {
        return "";
    }

    public String getBaseURI() {
        return "";
    }

    public int getLineNumber() {
        return -1;
    }

    public String getURIForPrefix(String string) throws XPathException {
        String string2 = (String)this.namespaces.get(string);
        if (string2 == null) {
            throw new XPathException.Static("Prefix " + string + " has not been declared");
        }
        return string2;
    }

    public VariableDeclaration bindVariable(int n) throws XPathException {
        Variable variable = (Variable)this.variables.get(new Integer(n));
        if (variable == null) {
            throw new XPathException.Static("Undeclared variable in a standalone expression");
        }
        return variable;
    }

    public Expression bindFunction(String string, Expression[] expressionArray) throws XPathException {
        String string2;
        String string3;
        int n = string.indexOf(":");
        if (n < 0) {
            FunctionCall functionCall = SystemFunction.makeSystemFunction(string);
            if (functionCall == null) {
                throw new XPathException.Static("Unknown system function: " + string);
            }
            if (functionCall instanceof XSLTFunction) {
                throw new XPathException.Static("Function " + string + " is available only in XSLT");
            }
            functionCall.setArguments(expressionArray);
            return functionCall;
        }
        String string4 = string.substring(0, n);
        int n2 = this.namePool.allocate(string4, string3 = this.getURIForPrefix(string4), string2 = string.substring(n + 1));
        int n3 = n2 & 0xFFFFF;
        if (n3 == this.namePool.getFingerprint("http://saxon.sf.net/", "evaluate")) {
            FunctionCall functionCall = SystemFunction.makeSystemFunction("saxon:evaluate");
            functionCall.setArguments(expressionArray);
            return functionCall;
        }
        if (n3 == this.namePool.getFingerprint("http://saxon.sf.net/", "expression")) {
            FunctionCall functionCall = SystemFunction.makeSystemFunction("saxon:expression");
            functionCall.setArguments(expressionArray);
            return functionCall;
        }
        if (n3 == this.namePool.getFingerprint("http://saxon.sf.net/", "parse")) {
            FunctionCall functionCall = SystemFunction.makeSystemFunction("saxon:parse");
            functionCall.setArguments(expressionArray);
            return functionCall;
        }
        if (n3 == this.namePool.getFingerprint("http://saxon.sf.net/", "serialize")) {
            FunctionCall functionCall = SystemFunction.makeSystemFunction("saxon:serialize");
            functionCall.setArguments(expressionArray);
            return functionCall;
        }
        if (string3.equals("http://www.w3.org/2001/XMLSchema") || string3.equals("http://www.w3.org/2001/XMLSchema-datatypes") || string3.equals("http://www.w3.org/2003/05/xpath-datatypes")) {
            if (expressionArray.length != 1) {
                throw new XPathException.Static("A constructor function must have exactly one argument");
            }
            SequenceType sequenceType = new SequenceType(Type.getNamedType(string3, string2), 88, 512);
            return new CastExpression(expressionArray[0], sequenceType);
        }
        Class clazz = null;
        try {
            clazz = this.getExternalJavaClass(string3);
        }
        catch (Exception exception) {
            throw new XPathException.Static("Cannot load external Java class", exception);
        }
        if (clazz != null) {
            FunctionProxy functionProxy = new FunctionProxy();
            functionProxy.setArguments(expressionArray);
            functionProxy.setFunctionName(clazz, string2);
            return functionProxy;
        }
        throw new XPathException.Static("Unknown function: " + string);
    }

    public FunctionSignature getFunctionSignature(int n, int n2) {
        throw new UnsupportedOperationException("method not yet implemented");
    }

    private Class getExternalJavaClass(String string) {
        Class clazz = FunctionProxy.getVendorExtensionClass(string);
        if (clazz != null) {
            return clazz;
        }
        return FunctionProxy.getImplicitJavaClass(string);
    }

    public Comparator getCollation(String string) {
        try {
            return CollationFactory.makeCollationFromURI(string);
        }
        catch (TransformerException transformerException) {
            return null;
        }
    }

    public String getDefaultCollationName() {
        if (this.defaultCollationName != null) {
            return this.defaultCollationName;
        }
        return CodepointCollator.URI;
    }

    public short getDefaultElementNamespace() {
        return 0;
    }

    public boolean isInBackwardsCompatibleMode() {
        return false;
    }
}

