/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.DateValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.DurationValue;
import net.sf.saxon.value.FloatValue;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.MonthDurationValue;
import net.sf.saxon.value.RestrictedStringValue;
import net.sf.saxon.value.SecondsDurationValue;
import net.sf.saxon.value.TimeValue;
import net.sf.saxon.value.Type;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Value;
import net.sf.saxon.xpath.XPathException;

public class StringValue
extends AtomicValue {
    public static final StringValue EMPTY_STRING = new StringValue("");
    protected CharSequence value;
    protected int length = -1;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$net$sf$saxon$value$StringValue;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$CharSequence;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;

    protected StringValue() {
        this.value = "";
    }

    public StringValue(CharSequence charSequence) {
        this.value = charSequence == null ? "" : charSequence;
    }

    public final String getStringValue() {
        this.value = this.value.toString();
        return this.value;
    }

    public AtomicValue convert(int n) throws XPathException {
        switch (n) {
            case 102: {
                String string = Value.collapseWhitespace(this.value).toString();
                if (string.equals("0") || string.equals("false")) {
                    return BooleanValue.FALSE;
                }
                if (string.equals("1") || string.equals("true")) {
                    return BooleanValue.TRUE;
                }
                throw new XPathException.Dynamic("The string '" + string + "' cannot be cast to a boolean");
            }
            case 91: {
                String string = Value.collapseWhitespace(this.value).toString();
                try {
                    if (string.indexOf(101) >= 0 || string.indexOf(69) >= 0) {
                        double d = new Double(string);
                        return new DoubleValue(d);
                    }
                    if (string.indexOf(46) >= 0 || string.length() > 18) {
                        return new DecimalValue(string);
                    }
                    long l = new Long(string);
                    return new IntegerValue(l);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new XPathException.Dynamic("Cannot convert string \"" + string + "\" to a number");
                }
            }
            case 105: {
                return new DoubleValue(Value.stringToNumber(this.value));
            }
            case 200: {
                return new IntegerValue(Value.stringToInteger(this.value));
            }
            case 201: 
            case 202: 
            case 203: 
            case 204: 
            case 205: 
            case 206: 
            case 207: 
            case 208: 
            case 209: 
            case 210: 
            case 211: 
            case 212: {
                return new IntegerValue(Value.stringToInteger(this.value), n);
            }
            case 103: {
                return new DecimalValue(this.value);
            }
            case 104: {
                return new FloatValue((float)Value.stringToNumber(this.value));
            }
            case 109: {
                return new DateValue(this.value);
            }
            case 107: {
                return new DateTimeValue(this.value);
            }
            case 108: {
                return new TimeValue(this.value);
            }
            case 106: {
                return new DurationValue(this.value);
            }
            case 240: {
                return new MonthDurationValue(this.value);
            }
            case 241: {
                return new SecondsDurationValue(this.value);
            }
            case 125: {
                return new UntypedAtomicValue(this.value);
            }
            case 88: 
            case 90: 
            case 101: {
                return this;
            }
            case 220: 
            case 221: 
            case 222: 
            case 223: 
            case 225: 
            case 226: 
            case 227: 
            case 228: 
            case 230: {
                return new RestrictedStringValue(this.value, n);
            }
            case 117: {
                return new AnyURIValue(this.value);
            }
        }
        throw new XPathException.Dynamic("Cannot convert string to " + Type.getTypeName(n));
    }

    public int getItemType() {
        return 101;
    }

    public int getLength() {
        if (this.length == -1) {
            this.length = StringValue.getLength(this.value);
        }
        return this.length;
    }

    public static int getLength(CharSequence charSequence) {
        int n = 0;
        int n2 = 0;
        while (n2 < charSequence.length()) {
            char c = charSequence.charAt(n2);
            if (c < '\ud800' || c > '\udbff') {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    public SequenceIterator iterateCharacters() {
        return new CharacterIterator();
    }

    public static int[] expand(CharSequence charSequence) {
        int[] nArray = new int[StringValue.getLength(charSequence)];
        int n = 0;
        int n2 = 0;
        while (n2 < charSequence.length()) {
            int n3;
            int n4 = charSequence.charAt(n2);
            if (n4 >= 55296 && n4 <= 56319) {
                n3 = (n4 - 55296) * 1024 + (charSequence.charAt(n2 + 1) - 56320) + 65536;
                ++n2;
            } else {
                n3 = n4;
            }
            nArray[n++] = n3;
            ++n2;
        }
        return nArray;
    }

    public boolean equals(Object object) {
        return this.getStringValue().equals(((StringValue)object).getStringValue());
    }

    public int hashCode() {
        return this.getStringValue().hashCode();
    }

    public boolean effectiveBooleanValue(XPathContext xPathContext) {
        return this.value.length() > 0;
    }

    public int conversionPreference(Class clazz) {
        if (clazz == (class$java$lang$Object == null ? (class$java$lang$Object = StringValue.class$("java.lang.Object")) : class$java$lang$Object)) {
            return 50;
        }
        if (clazz.isAssignableFrom(class$net$sf$saxon$value$StringValue == null ? (class$net$sf$saxon$value$StringValue = StringValue.class$("net.sf.saxon.value.StringValue")) : class$net$sf$saxon$value$StringValue)) {
            return 0;
        }
        if (clazz == (class$java$lang$String == null ? (class$java$lang$String = StringValue.class$("java.lang.String")) : class$java$lang$String)) {
            return 1;
        }
        if (clazz == (class$java$lang$CharSequence == null ? (class$java$lang$CharSequence = StringValue.class$("java.lang.CharSequence")) : class$java$lang$CharSequence)) {
            return 1;
        }
        if (clazz == Boolean.TYPE) {
            return 16;
        }
        if (clazz == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = StringValue.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            return 17;
        }
        if (clazz == Byte.TYPE) {
            return 18;
        }
        if (clazz == (class$java$lang$Byte == null ? (class$java$lang$Byte = StringValue.class$("java.lang.Byte")) : class$java$lang$Byte)) {
            return 19;
        }
        if (clazz == Character.TYPE) {
            return 2;
        }
        if (clazz == (class$java$lang$Character == null ? (class$java$lang$Character = StringValue.class$("java.lang.Character")) : class$java$lang$Character)) {
            return 3;
        }
        if (clazz == Double.TYPE) {
            return 6;
        }
        if (clazz == (class$java$lang$Double == null ? (class$java$lang$Double = StringValue.class$("java.lang.Double")) : class$java$lang$Double)) {
            return 7;
        }
        if (clazz == Float.TYPE) {
            return 8;
        }
        if (clazz == (class$java$lang$Float == null ? (class$java$lang$Float = StringValue.class$("java.lang.Float")) : class$java$lang$Float)) {
            return 9;
        }
        if (clazz == Integer.TYPE) {
            return 10;
        }
        if (clazz == (class$java$lang$Integer == null ? (class$java$lang$Integer = StringValue.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            return 11;
        }
        if (clazz == Long.TYPE) {
            return 12;
        }
        if (clazz == (class$java$lang$Long == null ? (class$java$lang$Long = StringValue.class$("java.lang.Long")) : class$java$lang$Long)) {
            return 13;
        }
        if (clazz == Short.TYPE) {
            return 14;
        }
        if (clazz == (class$java$lang$Short == null ? (class$java$lang$Short = StringValue.class$("java.lang.Short")) : class$java$lang$Short)) {
            return 15;
        }
        return Integer.MAX_VALUE;
    }

    public Object convertToJava(Class clazz) throws XPathException {
        if (clazz == (class$java$lang$Object == null ? (class$java$lang$Object = StringValue.class$("java.lang.Object")) : class$java$lang$Object)) {
            return this.value;
        }
        if (clazz.isAssignableFrom(class$net$sf$saxon$value$StringValue == null ? (class$net$sf$saxon$value$StringValue = StringValue.class$("net.sf.saxon.value.StringValue")) : class$net$sf$saxon$value$StringValue)) {
            return this;
        }
        if (clazz == (class$java$lang$String == null ? (class$java$lang$String = StringValue.class$("java.lang.String")) : class$java$lang$String) || clazz == (class$java$lang$CharSequence == null ? (class$java$lang$CharSequence = StringValue.class$("java.lang.CharSequence")) : class$java$lang$CharSequence)) {
            return this.value;
        }
        if (clazz == Boolean.TYPE) {
            BooleanValue booleanValue = (BooleanValue)this.convert(102);
            return new Boolean(booleanValue.getValue());
        }
        if (clazz == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = StringValue.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            BooleanValue booleanValue = (BooleanValue)this.convert(102);
            return new Boolean(booleanValue.getValue());
        }
        if (clazz == Double.TYPE) {
            DoubleValue doubleValue = (DoubleValue)this.convert(105);
            return new Double(doubleValue.getValue());
        }
        if (clazz == (class$java$lang$Double == null ? (class$java$lang$Double = StringValue.class$("java.lang.Double")) : class$java$lang$Double)) {
            DoubleValue doubleValue = (DoubleValue)this.convert(105);
            return new Double(doubleValue.getValue());
        }
        if (clazz == Float.TYPE) {
            DoubleValue doubleValue = (DoubleValue)this.convert(105);
            return new Float(doubleValue.getValue());
        }
        if (clazz == (class$java$lang$Float == null ? (class$java$lang$Float = StringValue.class$("java.lang.Float")) : class$java$lang$Float)) {
            DoubleValue doubleValue = (DoubleValue)this.convert(105);
            return new Float(doubleValue.getValue());
        }
        if (clazz == Long.TYPE) {
            IntegerValue integerValue = (IntegerValue)this.convert(200);
            return new Long(integerValue.getValue());
        }
        if (clazz == (class$java$lang$Long == null ? (class$java$lang$Long = StringValue.class$("java.lang.Long")) : class$java$lang$Long)) {
            IntegerValue integerValue = (IntegerValue)this.convert(200);
            return new Long(integerValue.getValue());
        }
        if (clazz == Integer.TYPE) {
            IntegerValue integerValue = (IntegerValue)this.convert(200);
            return new Integer((int)integerValue.getValue());
        }
        if (clazz == (class$java$lang$Integer == null ? (class$java$lang$Integer = StringValue.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            IntegerValue integerValue = (IntegerValue)this.convert(200);
            return new Integer((int)integerValue.getValue());
        }
        if (clazz == Short.TYPE) {
            IntegerValue integerValue = (IntegerValue)this.convert(200);
            return new Short((short)integerValue.getValue());
        }
        if (clazz == (class$java$lang$Short == null ? (class$java$lang$Short = StringValue.class$("java.lang.Short")) : class$java$lang$Short)) {
            IntegerValue integerValue = (IntegerValue)this.convert(200);
            return new Short((short)integerValue.getValue());
        }
        if (clazz == Byte.TYPE) {
            IntegerValue integerValue = (IntegerValue)this.convert(200);
            return new Byte((byte)integerValue.getValue());
        }
        if (clazz == (class$java$lang$Byte == null ? (class$java$lang$Byte = StringValue.class$("java.lang.Byte")) : class$java$lang$Byte)) {
            IntegerValue integerValue = (IntegerValue)this.convert(200);
            return new Byte((byte)integerValue.getValue());
        }
        if (clazz == Character.TYPE || clazz == (class$java$lang$Character == null ? (class$java$lang$Character = StringValue.class$("java.lang.Character")) : class$java$lang$Character)) {
            if (this.value.length() == 1) {
                return new Character(this.value.charAt(0));
            }
            throw new XPathException.Dynamic("Cannot convert string to Java char unless length is 1");
        }
        throw new XPathException.Dynamic("Conversion of string to " + clazz.getName() + " is not supported");
    }

    public void display(int n) {
        System.err.println(ExpressionTool.indent(n) + "string (\"" + this.value + "\")");
    }

    public String toString() {
        return "\"" + this.value + "\"";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public final class CharacterIterator
    implements SequenceIterator {
        int pos = 0;
        int current;

        public boolean hasNext() {
            return this.pos < StringValue.this.value.length();
        }

        public Item next() {
            char c;
            this.current = (c = StringValue.this.value.charAt(this.pos++)) >= '\ud800' && c <= '\udbff' ? (c - 55296) * 1024 + (StringValue.this.value.charAt(this.pos++) - 56320) + 65536 : (int)c;
            return new IntegerValue(this.current);
        }

        public Item current() {
            return new IntegerValue(this.current);
        }

        public int position() {
            return this.pos + 1;
        }

        public SequenceIterator getAnother() {
            return new CharacterIterator();
        }
    }
}

