/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.util.ArrayList;
import net.sf.saxon.expr.ComputedExpression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Type;
import net.sf.saxon.value.Value;
import net.sf.saxon.xpath.XPathException;

public abstract class SequenceValue
extends Value {
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$net$sf$saxon$om$SequenceIterator;
    static /* synthetic */ Class class$net$sf$saxon$value$SequenceValue;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$net$sf$saxon$om$NodeInfo;
    static /* synthetic */ Class class$org$w3c$dom$Node;

    public int getItemType() {
        return 88;
    }

    public int getCardinality() {
        try {
            SequenceIterator sequenceIterator = this.iterate(null);
            if (sequenceIterator.hasNext()) {
                sequenceIterator.next();
                if (sequenceIterator.hasNext()) {
                    return 1536;
                }
                return 512;
            }
            return 256;
        }
        catch (XPathException xPathException) {
            return 1792;
        }
    }

    public Item itemAt(int n) throws XPathException {
        if (n < 0) {
            return null;
        }
        int n2 = 0;
        SequenceIterator sequenceIterator = this.iterate(null);
        while (sequenceIterator.hasNext()) {
            Item item = sequenceIterator.next();
            if (n2++ != n) continue;
            return item;
        }
        return null;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        SequenceIterator sequenceIterator = this.iterate(xPathContext);
        if (sequenceIterator.hasNext()) {
            return sequenceIterator.next();
        }
        return null;
    }

    public String evaluateAsString(XPathContext xPathContext) throws XPathException {
        StringValue stringValue = (StringValue)this.evaluateItem(xPathContext);
        if (stringValue == null) {
            return "";
        }
        return stringValue.getStringValue();
    }

    public boolean effectiveBooleanValue(XPathContext xPathContext) throws XPathException {
        SequenceIterator sequenceIterator = this.iterate(xPathContext);
        if (!sequenceIterator.hasNext()) {
            return false;
        }
        Item item = sequenceIterator.next();
        if (item instanceof NodeInfo) {
            return true;
        }
        if (item instanceof BooleanValue) {
            return ((BooleanValue)item).getValue() || sequenceIterator.hasNext();
        }
        if (item instanceof StringValue) {
            return !item.getStringValue().equals("") || sequenceIterator.hasNext();
        }
        if (item instanceof NumericValue) {
            return sequenceIterator.hasNext() || !item.equals(DoubleValue.ZERO) && item.equals(item);
        }
        return true;
    }

    public int conversionPreference(Class clazz) {
        if (clazz == (class$java$lang$Object == null ? (class$java$lang$Object = SequenceValue.class$("java.lang.Object")) : class$java$lang$Object)) {
            return 50;
        }
        if (clazz.isAssignableFrom(class$net$sf$saxon$om$SequenceIterator == null ? (class$net$sf$saxon$om$SequenceIterator = SequenceValue.class$("net.sf.saxon.om.SequenceIterator")) : class$net$sf$saxon$om$SequenceIterator)) {
            return 0;
        }
        if (clazz.isAssignableFrom(class$net$sf$saxon$value$SequenceValue == null ? (class$net$sf$saxon$value$SequenceValue = SequenceValue.class$("net.sf.saxon.value.SequenceValue")) : class$net$sf$saxon$value$SequenceValue)) {
            return 1;
        }
        if (clazz.isAssignableFrom(class$java$util$List == null ? (class$java$util$List = SequenceValue.class$("java.util.List")) : class$java$util$List)) {
            return 2;
        }
        try {
            SequenceIterator sequenceIterator = this.iterate(null);
            if (sequenceIterator.hasNext()) {
                Item item = sequenceIterator.next();
                if (item instanceof NodeInfo) {
                    return SequenceValue.nodeToJavaPreference((NodeInfo)item, clazz);
                }
                return ((AtomicValue)item).conversionPreference(clazz);
            }
        }
        catch (XPathException xPathException) {}
        return Integer.MAX_VALUE;
    }

    public static int nodeToJavaPreference(NodeInfo nodeInfo, Class clazz) {
        if (clazz == (class$java$lang$Object == null ? (class$java$lang$Object = SequenceValue.class$("java.lang.Object")) : class$java$lang$Object)) {
            return 50;
        }
        if ((class$net$sf$saxon$om$NodeInfo == null ? (class$net$sf$saxon$om$NodeInfo = SequenceValue.class$("net.sf.saxon.om.NodeInfo")) : class$net$sf$saxon$om$NodeInfo).isAssignableFrom(clazz)) {
            return 3;
        }
        if ((class$org$w3c$dom$Node == null ? (class$org$w3c$dom$Node = SequenceValue.class$("org.w3c.dom.Node")) : class$org$w3c$dom$Node).isAssignableFrom(clazz)) {
            return 4;
        }
        try {
            Value value = nodeInfo.getTypedValue();
            return value.conversionPreference(clazz);
        }
        catch (XPathException xPathException) {
            return Integer.MAX_VALUE;
        }
    }

    public Object convertToJava(Class clazz) throws XPathException {
        if (clazz == (class$java$lang$Object == null ? (class$java$lang$Object = SequenceValue.class$("java.lang.Object")) : class$java$lang$Object)) {
            return this.iterate(null);
        }
        if (clazz.isAssignableFrom(class$net$sf$saxon$value$SequenceValue == null ? (class$net$sf$saxon$value$SequenceValue = SequenceValue.class$("net.sf.saxon.value.SequenceValue")) : class$net$sf$saxon$value$SequenceValue)) {
            return this;
        }
        if (clazz.isAssignableFrom(class$net$sf$saxon$om$SequenceIterator == null ? (class$net$sf$saxon$om$SequenceIterator = SequenceValue.class$("net.sf.saxon.om.SequenceIterator")) : class$net$sf$saxon$om$SequenceIterator)) {
            return this.iterate(null);
        }
        if (clazz.isAssignableFrom(class$java$util$List == null ? (class$java$util$List = SequenceValue.class$("java.util.List")) : class$java$util$List)) {
            ArrayList<Item> arrayList = new ArrayList<Item>();
            SequenceIterator sequenceIterator = this.iterate(null);
            while (sequenceIterator.hasNext()) {
                arrayList.add(sequenceIterator.next());
            }
            return arrayList;
        }
        SequenceIterator sequenceIterator = this.iterate(null);
        if (sequenceIterator.hasNext()) {
            Item item = sequenceIterator.next();
            if (item instanceof NodeInfo) {
                if (clazz.isAssignableFrom(item.getClass())) {
                    return item;
                }
                return item.getTypedValue().convertToJava(clazz);
            }
            return ((AtomicValue)item).convertToJava(clazz);
        }
        return null;
    }

    public void display(int n) {
        try {
            System.err.println(ExpressionTool.indent(n) + "sequence of " + Type.getTypeName(this.getItemType()) + " (");
            SequenceIterator sequenceIterator = this.iterate(null);
            while (sequenceIterator.hasNext()) {
                ((ComputedExpression)((Object)sequenceIterator.next())).display(n + 1);
            }
            System.err.println(ExpressionTool.indent(n) + ")");
        }
        catch (Exception exception) {}
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

