/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.io.Serializable;
import net.sf.saxon.value.Type;

public final class SequenceType
implements Serializable {
    private int primaryType;
    private int contentType;
    private int cardinality;
    public static final SequenceType ANY_SEQUENCE = new SequenceType(88, 88, 1792);
    public static final SequenceType SINGLE_ITEM = new SequenceType(88, 88, 512);
    public static final SequenceType SINGLE_STRING = new SequenceType(101, 88, 512);
    public static final SequenceType SINGLE_INTEGER = new SequenceType(200, 88, 512);
    public static final SequenceType SINGLE_NODE = new SequenceType(0, 88, 512);
    public static final SequenceType NODE_SEQUENCE = new SequenceType(0, 88, 1792);

    public SequenceType(int n, int n2, int n3) {
        this.primaryType = n;
        this.contentType = n2;
        this.cardinality = n3;
    }

    public int getPrimaryType() {
        return this.primaryType;
    }

    public int getContentType() {
        return this.contentType;
    }

    public int getCardinality() {
        return this.cardinality;
    }

    public String toString() {
        String string = Type.getTypeName(this.primaryType);
        if (this.contentType != 88) {
            string = string + " of type " + Type.getTypeName(this.contentType);
        }
        if (this.cardinality == 1536) {
            string = string + " +";
        } else if (this.cardinality == 1792) {
            string = string + " *";
        } else if (this.cardinality == 768) {
            string = string + " ?";
        }
        return string;
    }
}

