/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.Type;
import net.sf.saxon.xpath.XPathException;

public abstract class NumericValue
extends AtomicValue
implements Comparable {
    public double asDouble() {
        try {
            return ((DoubleValue)this.convert(105)).getValue();
        }
        catch (XPathException xPathException) {
            return Double.NaN;
        }
    }

    public boolean isNaN() {
        return false;
    }

    public long asLong() throws XPathException {
        return ((IntegerValue)this.convert(200)).getValue();
    }

    public abstract NumericValue negate() throws XPathException;

    public abstract NumericValue floor();

    public abstract NumericValue ceiling();

    public abstract NumericValue round();

    public abstract NumericValue roundToHalfEven(int var1);

    public abstract NumericValue arithmetic(int var1, NumericValue var2) throws XPathException;

    public abstract boolean isWholeNumber();

    public int compareTo(Object object) {
        double d;
        if (!(object instanceof NumericValue)) {
            throw new ClassCastException("Numeric values are not comparable to " + object.getClass());
        }
        double d2 = this.asDouble();
        if (d2 == (d = ((NumericValue)object).asDouble())) {
            return 0;
        }
        if (d2 < d) {
            return -1;
        }
        return 1;
    }

    public final boolean equals(Object object) {
        return this.compareTo(object) == 0;
    }

    public static int promote(int n, int n2) {
        int n3;
        int n4 = Type.isSubType(n, 91) ? n : 105;
        int n5 = n3 = Type.isSubType(n2, 91) ? n2 : 105;
        if (n4 == n3) {
            return n4;
        }
        if (n4 == 105 || n3 == 105) {
            return 105;
        }
        if (n4 == 104 || n3 == 104) {
            return 104;
        }
        if (n4 == 103 || n3 == 103) {
            return 103;
        }
        return 200;
    }

    public abstract int hashCode();

    public String toString() {
        try {
            return this.getStringValue();
        }
        catch (XPathException xPathException) {
            return "?";
        }
    }
}

