/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.util.StringTokenizer;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.MonthDurationValue;
import net.sf.saxon.value.SecondsDurationValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Type;
import net.sf.saxon.value.Value;
import net.sf.saxon.xpath.XPathException;

public class DurationValue
extends AtomicValue
implements Comparable {
    protected boolean negative = false;
    protected int years = 0;
    protected int months = 0;
    protected int days = 0;
    protected int hours = 0;
    protected int minutes = 0;
    protected int seconds = 0;
    protected int milliseconds = 0;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$net$sf$saxon$value$DurationValue;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$CharSequence;

    protected DurationValue() {
    }

    public DurationValue(CharSequence charSequence) throws XPathException {
        StringTokenizer stringTokenizer = new StringTokenizer(Value.collapseWhitespace(charSequence).toString(), "-+.PYMDTHS", true);
        try {
            String string;
            if (!stringTokenizer.hasMoreElements()) {
                this.badDuration("empty string", charSequence);
            }
            if ((string = (String)stringTokenizer.nextElement()).equals("+")) {
                string = (String)stringTokenizer.nextElement();
            } else if (string.equals("-")) {
                this.negative = true;
                string = (String)stringTokenizer.nextElement();
            }
            if (!string.equals("P")) {
                this.badDuration("missing 'P'", charSequence);
            }
            int n = 0;
            while (stringTokenizer.hasMoreElements()) {
                string = (String)stringTokenizer.nextElement();
                if (string.equals("T")) {
                    n = 4;
                    string = (String)stringTokenizer.nextElement();
                }
                int n2 = Integer.parseInt(string);
                if (!stringTokenizer.hasMoreElements()) {
                    this.badDuration("missing unit letter at end", charSequence);
                }
                char c = ((String)stringTokenizer.nextElement()).charAt(0);
                switch (c) {
                    case 'Y': {
                        if (n > 0) {
                            this.badDuration("Y is out of sequence", charSequence);
                        }
                        this.years = n2;
                        n = 1;
                        break;
                    }
                    case 'M': {
                        if (n == 4 || n == 5) {
                            this.minutes = n2;
                            n = 6;
                            break;
                        }
                        if (n == 0 || n == 1) {
                            this.months = n2;
                            n = 2;
                            break;
                        }
                        this.badDuration("M is out of sequence", charSequence);
                    }
                    case 'D': {
                        if (n > 2) {
                            this.badDuration("D is out of sequence", charSequence);
                        }
                        this.days = n2;
                        n = 3;
                        break;
                    }
                    case 'H': {
                        if (n != 4) {
                            this.badDuration("H is out of sequence", charSequence);
                        }
                        this.hours = n2;
                        n = 5;
                        break;
                    }
                    case '.': {
                        if (n > 6) {
                            this.badDuration("misplaced decimal point", charSequence);
                        }
                        this.seconds = n2;
                        n = 7;
                        break;
                    }
                    case 'S': {
                        if (n > 7) {
                            this.badDuration("S is out of sequence", charSequence);
                        }
                        if (n == 7) {
                            while (string.length() < 3) {
                                string = string + "0";
                            }
                            if (string.length() > 3) {
                                string = string.substring(0, 3);
                            }
                            this.milliseconds = Integer.parseInt(string);
                        } else {
                            this.seconds = n2;
                        }
                        n = 8;
                        break;
                    }
                    default: {
                        this.badDuration("misplaced " + c, charSequence);
                    }
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.badDuration("non-numeric component", charSequence);
        }
    }

    protected void badDuration(String string, CharSequence charSequence) throws XPathException {
        throw new XPathException.Dynamic("Invalid duration value '" + charSequence + "' (" + string + ")");
    }

    public AtomicValue convert(int n) throws XPathException {
        switch (n) {
            case 88: 
            case 90: 
            case 106: {
                return this;
            }
            case 101: {
                return new StringValue(this.getStringValue());
            }
            case 240: {
                if (this.days != 0 || this.hours != 0 || this.minutes != 0 || this.seconds != 0 || this.milliseconds != 0) {
                    throw new XPathException.Dynamic("Cannot convert to yearMonthDuration because some components are non-zero");
                }
                return MonthDurationValue.fromMonths((this.years * 12 + this.months) * (this.negative ? -1 : 1));
            }
            case 241: {
                if (this.years != 0 || this.months != 0) {
                    throw new XPathException.Dynamic("Cannot convert to dayTimeDuration because some components are non-zero");
                }
                return SecondsDurationValue.fromSeconds(this.getLengthInSeconds());
            }
        }
        throw new XPathException.Dynamic("Cannot convert duration to " + Type.getTypeName(n));
    }

    public String getStringValue() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.negative) {
            stringBuffer.append('-');
        }
        stringBuffer.append('P');
        stringBuffer.append(this.years);
        stringBuffer.append('Y');
        stringBuffer.append(this.months);
        stringBuffer.append('M');
        stringBuffer.append(this.days);
        stringBuffer.append('D');
        stringBuffer.append('T');
        stringBuffer.append(this.hours);
        stringBuffer.append('H');
        stringBuffer.append(this.minutes);
        stringBuffer.append('M');
        stringBuffer.append(this.seconds);
        if (this.milliseconds != 0) {
            stringBuffer.append('.');
            DateTimeValue.appendString(stringBuffer, this.milliseconds, 3);
        }
        stringBuffer.append('S');
        return stringBuffer.toString();
    }

    public double getLengthInSeconds() {
        double d = this.years;
        d = d * 12.0 + (double)this.months;
        d = d * 30.43684991666667 + (double)this.days;
        d = d * 24.0 + (double)this.hours;
        d = d * 60.0 + (double)this.minutes;
        d = d * 60.0 + (double)this.seconds;
        return this.negative ? -d : (d += (double)this.milliseconds / 1000.0);
    }

    public int getItemType() {
        return 106;
    }

    public int conversionPreference(Class clazz) {
        if (clazz == (class$java$lang$Object == null ? (class$java$lang$Object = DurationValue.class$("java.lang.Object")) : class$java$lang$Object)) {
            return 50;
        }
        if (clazz.isAssignableFrom(class$net$sf$saxon$value$DurationValue == null ? (class$net$sf$saxon$value$DurationValue = DurationValue.class$("net.sf.saxon.value.DurationValue")) : class$net$sf$saxon$value$DurationValue)) {
            return 0;
        }
        if (clazz == (class$java$lang$String == null ? (class$java$lang$String = DurationValue.class$("java.lang.String")) : class$java$lang$String) || clazz == (class$java$lang$CharSequence == null ? (class$java$lang$CharSequence = DurationValue.class$("java.lang.CharSequence")) : class$java$lang$CharSequence)) {
            return 3;
        }
        return Integer.MAX_VALUE;
    }

    public Object convertToJava(Class clazz) throws XPathException {
        if (clazz.isAssignableFrom(class$net$sf$saxon$value$DurationValue == null ? (class$net$sf$saxon$value$DurationValue = DurationValue.class$("net.sf.saxon.value.DurationValue")) : class$net$sf$saxon$value$DurationValue)) {
            return this;
        }
        if (clazz == (class$java$lang$String == null ? (class$java$lang$String = DurationValue.class$("java.lang.String")) : class$java$lang$String) || clazz == (class$java$lang$CharSequence == null ? (class$java$lang$CharSequence = DurationValue.class$("java.lang.CharSequence")) : class$java$lang$CharSequence)) {
            return this.getStringValue();
        }
        if (clazz == (class$java$lang$Object == null ? (class$java$lang$Object = DurationValue.class$("java.lang.Object")) : class$java$lang$Object)) {
            return this.getStringValue();
        }
        throw new XPathException.Dynamic("Conversion of duration to " + clazz.getName() + " is not supported");
    }

    public AtomicValue getComponent(int n) throws XPathException {
        switch (n) {
            case 1: {
                return new IntegerValue(this.negative ? -this.years : this.years);
            }
            case 2: {
                return new IntegerValue(this.negative ? -this.months : this.months);
            }
            case 3: {
                return new IntegerValue(this.negative ? -this.days : this.days);
            }
            case 4: {
                return new IntegerValue(this.negative ? -this.hours : this.hours);
            }
            case 5: {
                return new IntegerValue(this.negative ? -this.minutes : this.minutes);
            }
            case 6: {
                StringBuffer stringBuffer = new StringBuffer();
                String string = "000" + this.milliseconds;
                string = string.substring(string.length() - 3);
                stringBuffer.append((this.negative ? "-" : "") + this.seconds + '.' + string);
                return new DecimalValue(stringBuffer.toString());
            }
        }
        throw new IllegalArgumentException("Unknown component for duration: " + n);
    }

    public int compareTo(Object object) {
        double d;
        if (!(object instanceof DurationValue)) {
            throw new ClassCastException("Duration values are not comparable to " + object.getClass());
        }
        double d2 = this.getLengthInSeconds();
        if (d2 == (d = ((DurationValue)object).getLengthInSeconds())) {
            return 0;
        }
        if (d2 < d) {
            return -1;
        }
        return 1;
    }

    public boolean equals(Object object) {
        return this.compareTo(object) == 0;
    }

    public int hashCode() {
        return new Double(this.getLengthInSeconds()).hashCode();
    }

    public DurationValue add(DurationValue durationValue) throws XPathException {
        throw new XPathException.Dynamic("Only subtypes of xs:duration can be added");
    }

    public DurationValue subtract(DurationValue durationValue) throws XPathException {
        throw new XPathException.Dynamic("Only subtypes of xs:duration can be subtracted");
    }

    public DurationValue multiply(double d) throws XPathException {
        throw new XPathException.Dynamic("Only subtypes of xs:duration can be multiplied by a number");
    }

    public void display(int n) {
        System.err.println(ExpressionTool.indent(n) + "duration (" + this.getStringValue() + ")");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

