/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.CalendarValue;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Type;
import net.sf.saxon.value.Value;
import net.sf.saxon.xpath.XPathException;

public final class DateValue
extends CalendarValue
implements Comparable {
    private GregorianCalendar calendar;
    private boolean zoneSpecified = false;
    private int tzOffset = 0;
    private Date UTCDate = null;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$net$sf$saxon$value$DateValue;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$CharSequence;
    static /* synthetic */ Class class$net$sf$saxon$value$DateTimeValue;

    public DateValue(CharSequence charSequence) throws XPathException {
        StringTokenizer stringTokenizer = new StringTokenizer(Value.collapseWhitespace(charSequence).toString(), "-:+Z", true);
        try {
            if (!stringTokenizer.hasMoreElements()) {
                this.badDate("too short");
            }
            String string = (String)stringTokenizer.nextElement();
            int n = 1;
            if (string.equals("+")) {
                string = (String)stringTokenizer.nextElement();
            } else if (string.equals("-")) {
                n = -1;
                string = (String)stringTokenizer.nextElement();
            }
            int n2 = Integer.parseInt(string) * n;
            if (string.length() < 4) {
                this.badDate("year is less than four digits");
            }
            if (n2 == 0) {
                this.badDate("year zero is not allowed");
            }
            if (!stringTokenizer.hasMoreElements()) {
                this.badDate("too short");
            }
            if (!stringTokenizer.nextElement().equals("-")) {
                this.badDate("wrong delimiter after year");
            }
            if (!stringTokenizer.hasMoreElements()) {
                this.badDate("too short");
            }
            string = (String)stringTokenizer.nextElement();
            int n3 = Integer.parseInt(string);
            if (string.length() != 2) {
                this.badDate("month must be two digits");
            }
            if (n3 < 1 || n3 > 12) {
                this.badDate("month is out of range");
            }
            if (!stringTokenizer.hasMoreElements()) {
                this.badDate("too short");
            }
            if (!stringTokenizer.nextElement().equals("-")) {
                this.badDate("wrong delimiter after month");
            }
            if (!stringTokenizer.hasMoreElements()) {
                this.badDate("too short");
            }
            string = (String)stringTokenizer.nextElement();
            int n4 = Integer.parseInt(string);
            if (string.length() != 2) {
                this.badDate("day must be two digits");
            }
            if (n4 < 1 || n4 > 31) {
                this.badDate("day is out of range");
            }
            if (stringTokenizer.hasMoreElements()) {
                String string2 = (String)stringTokenizer.nextElement();
                if (string2.equals("Z")) {
                    this.zoneSpecified = true;
                    this.tzOffset = 0;
                    if (stringTokenizer.hasMoreElements()) {
                        this.badDate("continues after 'Z'");
                    }
                } else if (string2.equals("+") || string2.equals("-")) {
                    this.zoneSpecified = true;
                    if (!stringTokenizer.hasMoreElements()) {
                        this.badDate("missing timezone");
                    }
                    string = (String)stringTokenizer.nextElement();
                    int n5 = Integer.parseInt(string);
                    if (string.length() != 2) {
                        this.badDate("timezone hour must be two digits");
                    }
                    if (n5 > 14) {
                        this.badDate("timezone hour is out of range");
                    }
                    if (!stringTokenizer.hasMoreElements()) {
                        this.badDate("no minutes in timezone");
                    }
                    if (!stringTokenizer.nextElement().equals(":")) {
                        this.badDate("wrong delimiter after timezone hour");
                    }
                    if (!stringTokenizer.hasMoreElements()) {
                        this.badDate("no minutes in timezone");
                    }
                    string = (String)stringTokenizer.nextElement();
                    int n6 = Integer.parseInt(string);
                    if (string.length() != 2) {
                        this.badDate("timezone minute must be two digits");
                    }
                    if (n6 > 59) {
                        this.badDate("timezone minute is out of range");
                    }
                    if (stringTokenizer.hasMoreElements()) {
                        this.badDate("continues after timezone");
                    }
                    this.tzOffset = n5 * 60 + n6;
                    if (string2.equals("-")) {
                        this.tzOffset = -this.tzOffset;
                    }
                } else {
                    this.badDate("timezone format is incorrect");
                }
            }
            this.calendar = new GregorianCalendar();
            this.calendar.clear();
            this.calendar.setLenient(false);
            this.calendar.set(n2, n3 - 1, n4);
            try {
                this.calendar.getTime();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.badDate("non-existent date");
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.badDate("non-numeric component");
        }
    }

    private void badDate(String string) throws XPathException {
        throw new XPathException.Dynamic("Invalid date format (" + string + ")");
    }

    public Date getUTCDate() {
        if (this.UTCDate == null) {
            this.UTCDate = this.calendar.getTime();
        }
        return this.UTCDate;
    }

    public AtomicValue convert(int n) throws XPathException {
        switch (n) {
            case 88: 
            case 90: 
            case 109: {
                return this;
            }
            case 107: {
                return new DateTimeValue(this.calendar, this.zoneSpecified);
            }
            case 101: {
                return new StringValue(this.getStringValue());
            }
        }
        throw new XPathException.Dynamic("Cannot convert date to " + Type.getTypeName(n));
    }

    public String getStringValue() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.calendar.get(1);
        if (n < 0) {
            stringBuffer.append('-');
            n = -n;
        }
        DateTimeValue.appendString(stringBuffer, n, n > 9999 ? (this.calendar.get(1) + "").length() : 4);
        stringBuffer.append('-');
        DateTimeValue.appendString(stringBuffer, this.calendar.get(2) + 1, 2);
        stringBuffer.append('-');
        DateTimeValue.appendString(stringBuffer, this.calendar.get(5), 2);
        if (this.zoneSpecified) {
            if (this.tzOffset == 0) {
                stringBuffer.append('Z');
            } else {
                stringBuffer.append(this.tzOffset < 0 ? "-" : "+");
                int n2 = this.tzOffset;
                if (n2 < 0) {
                    n2 = -n2;
                }
                int n3 = n2 / 60;
                DateTimeValue.appendString(stringBuffer, n3, 2);
                stringBuffer.append(':');
                int n4 = n2 % 60;
                DateTimeValue.appendString(stringBuffer, n4, 2);
            }
        }
        return stringBuffer.toString();
    }

    public int getItemType() {
        return 109;
    }

    public int conversionPreference(Class clazz) {
        if (clazz == (class$java$lang$Object == null ? (class$java$lang$Object = DateValue.class$("java.lang.Object")) : class$java$lang$Object)) {
            return 50;
        }
        if (clazz.isAssignableFrom(class$net$sf$saxon$value$DateValue == null ? (class$net$sf$saxon$value$DateValue = DateValue.class$("net.sf.saxon.value.DateValue")) : class$net$sf$saxon$value$DateValue)) {
            return 0;
        }
        if (clazz.isAssignableFrom(class$java$util$Date == null ? (class$java$util$Date = DateValue.class$("java.util.Date")) : class$java$util$Date)) {
            return 1;
        }
        if (clazz == (class$java$lang$String == null ? (class$java$lang$String = DateValue.class$("java.lang.String")) : class$java$lang$String) || clazz == (class$java$lang$CharSequence == null ? (class$java$lang$CharSequence = DateValue.class$("java.lang.CharSequence")) : class$java$lang$CharSequence)) {
            return 3;
        }
        return Integer.MAX_VALUE;
    }

    public Object convertToJava(Class clazz) throws XPathException {
        if (clazz.isAssignableFrom(class$java$util$Date == null ? (class$java$util$Date = DateValue.class$("java.util.Date")) : class$java$util$Date)) {
            return this.getUTCDate();
        }
        if (clazz.isAssignableFrom(class$net$sf$saxon$value$DateTimeValue == null ? (class$net$sf$saxon$value$DateTimeValue = DateValue.class$("net.sf.saxon.value.DateTimeValue")) : class$net$sf$saxon$value$DateTimeValue)) {
            return this;
        }
        if (clazz == (class$java$lang$String == null ? (class$java$lang$String = DateValue.class$("java.lang.String")) : class$java$lang$String) || clazz == (class$java$lang$CharSequence == null ? (class$java$lang$CharSequence = DateValue.class$("java.lang.CharSequence")) : class$java$lang$CharSequence)) {
            return this.getStringValue();
        }
        if (clazz == (class$java$lang$Object == null ? (class$java$lang$Object = DateValue.class$("java.lang.Object")) : class$java$lang$Object)) {
            return this.getStringValue();
        }
        throw new XPathException.Dynamic("Conversion of date to " + clazz.getName() + " is not supported");
    }

    public AtomicValue getComponent(int n) {
        switch (n) {
            case 1: {
                return new IntegerValue(this.calendar.get(1));
            }
            case 2: {
                return new IntegerValue(this.calendar.get(2) + 1);
            }
            case 3: {
                return new IntegerValue(this.calendar.get(5));
            }
            case 7: {
                if (this.zoneSpecified) {
                    StringBuffer stringBuffer = new StringBuffer();
                    DateTimeValue.appendTimezone(this.calendar, stringBuffer);
                    return new StringValue(stringBuffer);
                }
                return null;
            }
        }
        throw new IllegalArgumentException("Unknown component for date: " + n);
    }

    public int compareTo(Object object) {
        if (!(object instanceof DateValue)) {
            throw new ClassCastException("Date values are not comparable to " + object.getClass());
        }
        int n = this.getUTCDate().compareTo(((DateValue)object).getUTCDate());
        if (n == 0) {
            return ((DateValue)object).tzOffset - this.tzOffset;
        }
        return n;
    }

    public boolean equals(Object object) {
        return this.compareTo(object) == 0;
    }

    public int hashCode() {
        return this.getUTCDate().hashCode() + new Integer(this.tzOffset).hashCode();
    }

    public void display(int n) {
        System.err.println(ExpressionTool.indent(n) + "date (" + this.getStringValue() + ")");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

