/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.RestrictedStringValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Type;
import net.sf.saxon.value.Value;
import net.sf.saxon.xpath.XPathException;

public final class AnyURIValue
extends AtomicValue {
    private String value;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$net$sf$saxon$value$AnyURIValue;
    static /* synthetic */ Class class$java$net$URI;
    static /* synthetic */ Class class$java$net$URL;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$CharSequence;
    static /* synthetic */ Class class$net$sf$saxon$value$StringValue;

    public AnyURIValue(CharSequence charSequence) {
        this.value = charSequence == null ? "" : Value.collapseWhitespace(charSequence).toString();
    }

    public String getStringValue() {
        return this.value;
    }

    public AtomicValue convert(int n) throws XPathException {
        switch (n) {
            case 88: 
            case 90: 
            case 117: {
                return this;
            }
            case 101: {
                return new StringValue(this.value);
            }
            case 220: 
            case 221: 
            case 222: 
            case 223: 
            case 225: 
            case 226: 
            case 227: 
            case 228: 
            case 230: {
                return new RestrictedStringValue(this.value, n);
            }
        }
        throw new XPathException.Dynamic("Cannot convert anyURI to " + Type.getTypeName(n));
    }

    public int getItemType() {
        return 117;
    }

    public boolean equals(Object object) {
        return this.value.equals(((AnyURIValue)object).value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public int conversionPreference(Class clazz) {
        if (clazz == (class$java$lang$Object == null ? (class$java$lang$Object = AnyURIValue.class$("java.lang.Object")) : class$java$lang$Object)) {
            return 50;
        }
        if (clazz.isAssignableFrom(class$net$sf$saxon$value$AnyURIValue == null ? (class$net$sf$saxon$value$AnyURIValue = AnyURIValue.class$("net.sf.saxon.value.AnyURIValue")) : class$net$sf$saxon$value$AnyURIValue)) {
            return 0;
        }
        if (clazz == (class$java$net$URI == null ? (class$java$net$URI = AnyURIValue.class$("java.net.URI")) : class$java$net$URI)) {
            return 1;
        }
        if (clazz == (class$java$net$URL == null ? (class$java$net$URL = AnyURIValue.class$("java.net.URL")) : class$java$net$URL)) {
            return 2;
        }
        if (clazz == (class$java$lang$String == null ? (class$java$lang$String = AnyURIValue.class$("java.lang.String")) : class$java$lang$String)) {
            return 3;
        }
        if (clazz == (class$java$lang$CharSequence == null ? (class$java$lang$CharSequence = AnyURIValue.class$("java.lang.CharSequence")) : class$java$lang$CharSequence)) {
            return 3;
        }
        return Integer.MAX_VALUE;
    }

    public Object convertToJava(Class clazz) throws XPathException {
        if (clazz == (class$java$lang$Object == null ? (class$java$lang$Object = AnyURIValue.class$("java.lang.Object")) : class$java$lang$Object)) {
            return this.value;
        }
        if (clazz.isAssignableFrom(class$net$sf$saxon$value$StringValue == null ? (class$net$sf$saxon$value$StringValue = AnyURIValue.class$("net.sf.saxon.value.StringValue")) : class$net$sf$saxon$value$StringValue)) {
            return this;
        }
        if (clazz == (class$java$net$URI == null ? (class$java$net$URI = AnyURIValue.class$("java.net.URI")) : class$java$net$URI)) {
            try {
                return new URI(this.value);
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new XPathException.Dynamic("The anyURI value '" + this.value + "' is not an acceptable Java URI");
            }
        }
        if (clazz == (class$java$net$URL == null ? (class$java$net$URL = AnyURIValue.class$("java.net.URL")) : class$java$net$URL)) {
            try {
                return new URL(this.value);
            }
            catch (MalformedURLException malformedURLException) {
                throw new XPathException.Dynamic("The anyURI value '" + this.value + "' is not an acceptable Java URL");
            }
        }
        if (clazz == (class$java$lang$String == null ? (class$java$lang$String = AnyURIValue.class$("java.lang.String")) : class$java$lang$String)) {
            return this.value;
        }
        if (clazz == (class$java$lang$CharSequence == null ? (class$java$lang$CharSequence = AnyURIValue.class$("java.lang.CharSequence")) : class$java$lang$CharSequence)) {
            return this.value;
        }
        throw new XPathException.Dynamic("Conversion of anyURI to " + clazz.getName() + " is not supported");
    }

    public void display(int n) {
        System.err.println(ExpressionTool.indent(n) + "anyURI (\"" + this.value + "\")");
    }

    public String toString() {
        return "\"" + this.value + "\"";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

