/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trace;

import net.sf.saxon.om.Item;
import net.sf.saxon.om.Navigator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.trace.InstructionInfo;
import net.sf.saxon.trace.TraceListener;

public class SimpleTraceListener
implements TraceListener {
    private int indent = 0;
    private static StringBuffer spaceBuffer = new StringBuffer("                ");

    public void open() {
        System.err.println("<trace>");
    }

    public void close() {
        System.err.println("</trace>");
    }

    public void enter(InstructionInfo instructionInfo) {
        String string = instructionInfo.getSystemId();
        if (string == null) {
            string = "";
        }
        if (string.length() > 15) {
            string = "*" + string.substring(string.length() - 14);
        }
        String string2 = instructionInfo.getInstructionName();
        String string3 = null;
        if (string2.equals("xsl:apply-templates")) {
            string3 = instructionInfo.getProperty("mode");
        }
        String string4 = instructionInfo.getProperty("name");
        System.err.println(SimpleTraceListener.spaces(this.indent) + "<Instruction element=\"" + string2 + "\" line=\"" + instructionInfo.getLineNumber() + "\" file=\"" + string + (string4 != null ? "\" name=\"" + string4 : "") + (string3 != null ? "\" mode=\"" + string3 : "") + "\">");
        ++this.indent;
    }

    public void leave(InstructionInfo instructionInfo) {
        --this.indent;
        System.err.println(SimpleTraceListener.spaces(this.indent) + "</Instruction> <!-- " + instructionInfo.getInstructionName() + " -->");
    }

    public void startCurrentItem(Item item) {
        if (item instanceof NodeInfo) {
            NodeInfo nodeInfo = (NodeInfo)item;
            System.err.println(SimpleTraceListener.spaces(this.indent) + "<Source node=\"" + Navigator.getPath(nodeInfo) + "\" line=\"" + nodeInfo.getLineNumber() + "\">");
        }
        ++this.indent;
    }

    public void endCurrentItem(Item item) {
        --this.indent;
        if (item instanceof NodeInfo) {
            NodeInfo nodeInfo = (NodeInfo)item;
            System.err.println(SimpleTraceListener.spaces(this.indent) + "</Source><!-- " + Navigator.getPath(nodeInfo) + " -->");
        }
    }

    private static String spaces(int n) {
        if (spaceBuffer.length() < n) {
            spaceBuffer.append(spaceBuffer);
        }
        return spaceBuffer.substring(0, n);
    }
}

