/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tinytree;

import net.sf.saxon.om.AxisIteratorImpl;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.tinytree.TinyDocumentImpl;
import net.sf.saxon.tinytree.TinyNodeImpl;

final class PrecedingEnumeration
extends AxisIteratorImpl {
    private TinyDocumentImpl document;
    private TinyNodeImpl startNode;
    private NodeTest test;
    private int nextNodeNr;
    private int nextAncestorDepth;
    private boolean includeAncestors;

    public PrecedingEnumeration(TinyDocumentImpl tinyDocumentImpl, TinyNodeImpl tinyNodeImpl, NodeTest nodeTest, boolean bl) {
        this.includeAncestors = bl;
        this.test = nodeTest;
        this.document = tinyDocumentImpl;
        this.startNode = tinyNodeImpl;
        this.nextNodeNr = tinyNodeImpl.nodeNr;
        this.nextAncestorDepth = tinyDocumentImpl.depth[this.nextNodeNr] - 1;
        this.advance();
    }

    public boolean hasNext() {
        return this.nextNodeNr >= 0;
    }

    public Item next() {
        ++this.position;
        this.current = this.document.getNode(this.nextNodeNr);
        this.advance();
        return this.current;
    }

    private void advance() {
        do {
            --this.nextNodeNr;
            if (this.includeAncestors) continue;
            while (this.nextNodeNr >= 0 && this.document.depth[this.nextNodeNr] == this.nextAncestorDepth) {
                --this.nextAncestorDepth;
                --this.nextNodeNr;
            }
        } while (this.nextNodeNr >= 0 && !this.test.matches(this.document.nodeKind[this.nextNodeNr], this.document.nameCode[this.nextNodeNr], this.document.getElementAnnotation(this.nextNodeNr)));
    }

    public SequenceIterator getAnother() {
        return new PrecedingEnumeration(this.document, this.startNode, this.test, this.includeAncestors);
    }
}

