/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tinytree;

import net.sf.saxon.om.AxisIteratorImpl;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.tinytree.TinyDocumentImpl;
import net.sf.saxon.tinytree.TinyNodeImpl;

final class DescendantEnumeration
extends AxisIteratorImpl {
    private TinyDocumentImpl document;
    private TinyNodeImpl startNode;
    private boolean includeSelf;
    private int nextNodeNr;
    private int startDepth;
    private NodeTest test;

    protected DescendantEnumeration(TinyDocumentImpl tinyDocumentImpl, TinyNodeImpl tinyNodeImpl, NodeTest nodeTest, boolean bl) {
        this.document = tinyDocumentImpl;
        this.startNode = tinyNodeImpl;
        this.includeSelf = bl;
        this.test = nodeTest;
        this.nextNodeNr = tinyNodeImpl.nodeNr;
        this.startDepth = tinyDocumentImpl.depth[this.nextNodeNr];
        if (!bl) {
            ++this.nextNodeNr;
            if (tinyDocumentImpl.depth[this.nextNodeNr] <= this.startDepth) {
                this.nextNodeNr = -1;
            }
        }
        if (this.nextNodeNr >= 0 && this.nextNodeNr < tinyDocumentImpl.numberOfNodes && !nodeTest.matches(this.document.nodeKind[this.nextNodeNr], this.document.nameCode[this.nextNodeNr], this.document.nodeKind[this.nextNodeNr] == 1 ? this.document.getElementAnnotation(this.nextNodeNr) : 0)) {
            this.advance();
        }
    }

    public boolean hasNext() {
        return this.nextNodeNr >= 0;
    }

    public Item next() {
        ++this.position;
        this.current = this.document.getNode(this.nextNodeNr);
        this.advance();
        return this.current;
    }

    private void advance() {
        do {
            ++this.nextNodeNr;
            if (this.nextNodeNr < this.document.numberOfNodes && this.document.depth[this.nextNodeNr] > this.startDepth) continue;
            this.nextNodeNr = -1;
            return;
        } while (!this.test.matches(this.document.nodeKind[this.nextNodeNr], this.document.nameCode[this.nextNodeNr], 88));
    }

    public SequenceIterator getAnother() {
        return new DescendantEnumeration(this.document, this.startNode, this.test, this.includeSelf);
    }
}

