/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import javax.xml.transform.TransformerConfigurationException;
import net.sf.saxon.expr.AtomicSequenceConverter;
import net.sf.saxon.expr.Atomizer;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FirstItemExpression;
import net.sf.saxon.functions.StringJoin;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.ValueOf;
import net.sf.saxon.style.StandardNames;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.tree.AttributeCollection;
import net.sf.saxon.value.Cardinality;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Type;
import net.sf.saxon.xpath.XPathException;

public final class XSLValueOf
extends StyleElement {
    private Expression select;
    private boolean disable = false;
    private Expression separator;

    public boolean isInstruction() {
        return true;
    }

    protected int getReturnedItemType() {
        return 3;
    }

    public void prepareAttributes() throws TransformerConfigurationException {
        String string = null;
        String string2 = null;
        String string3 = null;
        StandardNames standardNames = this.getStandardNames();
        AttributeCollection attributeCollection = this.getAttributeList();
        int n = 0;
        while (n < attributeCollection.getLength()) {
            int n2 = attributeCollection.getNameCode(n);
            int n3 = n2 & 0xFFFFF;
            if (n3 == standardNames.DISABLE_OUTPUT_ESCAPING) {
                string2 = attributeCollection.getValue(n).trim();
            } else if (n3 == standardNames.SELECT) {
                string = attributeCollection.getValue(n);
            } else if (n3 == standardNames.SEPARATOR) {
                string3 = attributeCollection.getValue(n);
            } else {
                this.checkUnknownAttribute(n2);
            }
            ++n;
        }
        if (string == null) {
            this.reportAbsence("select");
            return;
        }
        this.select = this.makeExpression(string);
        if (string3 != null) {
            this.separator = this.makeAttributeValueTemplate(string3);
        }
        if (string2 != null) {
            if (string2.equals("yes")) {
                this.disable = true;
            } else if (string2.equals("no")) {
                this.disable = false;
            } else {
                this.compileError("disable-output-escaping attribute must be either yes or no");
            }
        }
    }

    public void validate() throws TransformerConfigurationException {
        this.checkWithinTemplate();
        this.checkEmpty();
        this.select = this.typeCheck("select", this.select);
        this.separator = this.typeCheck("separator", this.separator);
    }

    public Instruction compile() throws TransformerConfigurationException {
        Expression[] expressionArray;
        try {
            if (this.separator == null && this.backwardsCompatibleModeIsEnabled()) {
                if (!Type.isSubType(this.select.getItemType(), 90)) {
                    this.select = new Atomizer(this.select);
                }
                if (Cardinality.allowsMany(this.select.getCardinality())) {
                    this.select = new FirstItemExpression(this.select);
                }
                if (!Type.isSubType(this.select.getItemType(), 101)) {
                    this.select = new AtomicSequenceConverter(this.select, 101);
                }
            } else {
                if (this.separator == null) {
                    this.separator = new StringValue(" ");
                }
                if (!Type.isSubType(this.select.getItemType(), 90)) {
                    this.select = new Atomizer(this.select);
                }
                if (!Type.isSubType(this.select.getItemType(), 101)) {
                    this.select = new AtomicSequenceConverter(this.select, 101);
                }
                expressionArray = new Expression[]{this.select, this.separator};
                StringJoin stringJoin = (StringJoin)SystemFunction.makeSystemFunction("string-join");
                stringJoin.setArguments(expressionArray);
                this.select = stringJoin;
            }
        }
        catch (XPathException xPathException) {
            this.compileError(xPathException);
        }
        expressionArray = new ValueOf(this.select, this.disable);
        this.compileChildren((Instruction)expressionArray);
        return expressionArray;
    }
}

