/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import javax.xml.transform.TransformerConfigurationException;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.Text;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.style.StandardNames;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLStringConstructor;
import net.sf.saxon.tree.AttributeCollection;

public class XSLText
extends XSLStringConstructor {
    private boolean disable = false;

    protected int getReturnedItemType() {
        return 3;
    }

    public void prepareAttributes() throws TransformerConfigurationException {
        String string = null;
        StandardNames standardNames = this.getStandardNames();
        AttributeCollection attributeCollection = this.getAttributeList();
        int n = 0;
        while (n < attributeCollection.getLength()) {
            int n2 = attributeCollection.getNameCode(n);
            int n3 = n2 & 0xFFFFF;
            if (n3 == standardNames.DISABLE_OUTPUT_ESCAPING) {
                string = attributeCollection.getValue(n).trim();
            } else {
                this.checkUnknownAttribute(n2);
            }
            ++n;
        }
        if (string != null) {
            if (string.equals("yes")) {
                this.disable = true;
            } else if (string.equals("no")) {
                this.disable = false;
            } else {
                this.compileError("disable-output-escaping attribute must be either yes or no");
            }
        }
    }

    public void validate() throws TransformerConfigurationException {
        this.checkWithinTemplate();
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        while (axisIterator.hasNext()) {
            if (!(axisIterator.next() instanceof StyleElement)) continue;
            this.compileError("xsl:text may not contain child elements");
            return;
        }
        this.optimize();
    }

    public Instruction compile() throws TransformerConfigurationException {
        Text text = new Text(this.disable);
        if (this.stringValue != null && this.stringValue.equals("")) {
            return null;
        }
        this.compileContent(text);
        return text;
    }
}

