/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import net.sf.saxon.PreparedStyleSheet;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.Navigator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.sort.CodepointCollator;
import net.sf.saxon.sort.CollationFactory;
import net.sf.saxon.sort.SortKeyDefinition;
import net.sf.saxon.style.DataElement;
import net.sf.saxon.style.SAXONCollation;
import net.sf.saxon.style.SAXONScript;
import net.sf.saxon.style.StandardNames;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLCharacterMap;
import net.sf.saxon.style.XSLGeneralIncorporate;
import net.sf.saxon.style.XSLNamespaceAlias;
import net.sf.saxon.style.XSLOutput;
import net.sf.saxon.style.XSLTemplate;
import net.sf.saxon.style.XSLVariableDeclaration;
import net.sf.saxon.trans.DecimalFormatManager;
import net.sf.saxon.trans.KeyManager;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.trans.RuleManager;
import net.sf.saxon.tree.AttributeCollection;

public class XSLStyleSheet
extends StyleElement {
    private NamePool targetNamePool;
    private boolean wasIncluded = false;
    private int precedence = 0;
    private int minImportPrecedence = 0;
    private XSLStyleSheet importer = null;
    private PreparedStyleSheet stylesheet;
    private List topLevel;
    private Mode stripperRules = null;
    private RuleManager ruleManager;
    private KeyManager keyManager;
    private DecimalFormatManager decimalFormatManager;
    private HashMap collationTable;
    private String defaultCollationName = null;
    private HashMap sortKeyTable;
    private HashMap characterMapIndex;
    private int numberOfAliases = 0;
    private ArrayList namespaceAliasList = new ArrayList(5);
    private short[] aliasSCodes;
    private int[] aliasNCodes;
    private int numberOfVariables = 0;
    private HashMap variableMap = new HashMap();
    private int largestStackFrame = 0;
    private boolean runtimeTemplateMapRequired = false;
    private HashMap stylesheetModules = new HashMap();

    public void setPreparedStyleSheet(PreparedStyleSheet preparedStyleSheet) {
        this.stylesheet = preparedStyleSheet;
        this.targetNamePool = preparedStyleSheet.getTargetNamePool();
        this.ruleManager = new RuleManager();
    }

    public PreparedStyleSheet getPreparedStyleSheet() {
        if (this.importer != null) {
            return this.importer.getPreparedStyleSheet();
        }
        return this.stylesheet;
    }

    public NamePool getTargetNamePool() {
        return this.targetNamePool;
    }

    protected int putModuleNumber(String string) {
        Integer n = (Integer)this.stylesheetModules.get(string);
        if (n == null) {
            n = new Integer(this.stylesheetModules.size());
            this.stylesheetModules.put(string, n);
        }
        return n;
    }

    protected int getModuleNumber(String string) {
        Integer n = (Integer)this.stylesheetModules.get(string);
        return n;
    }

    private String[] getModuleArray() {
        String[] stringArray = new String[this.stylesheetModules.size()];
        Iterator iterator = this.stylesheetModules.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            int n = this.getModuleNumber(string);
            stringArray[n] = string;
        }
        return stringArray;
    }

    public RuleManager getRuleManager() {
        return this.ruleManager;
    }

    public void setRequireRuntimeTemplateMap(boolean bl) {
        this.runtimeTemplateMapRequired = bl;
    }

    protected Mode getStripperRules() {
        if (this.stripperRules == null) {
            this.stripperRules = new Mode();
        }
        return this.stripperRules;
    }

    public boolean stripsWhitespace() {
        StandardNames standardNames = this.getStandardNames();
        int n = 0;
        while (n < this.topLevel.size()) {
            NodeInfo nodeInfo = (NodeInfo)this.topLevel.get(n);
            if (nodeInfo.getFingerprint() == standardNames.XSL_STRIP_SPACE) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public KeyManager getKeyManager() {
        if (this.keyManager == null) {
            this.keyManager = new KeyManager();
        }
        return this.keyManager;
    }

    public DecimalFormatManager getDecimalFormatManager() {
        if (this.decimalFormatManager == null) {
            this.decimalFormatManager = new DecimalFormatManager();
        }
        return this.decimalFormatManager;
    }

    public void setCollation(String string, Comparator comparator, boolean bl) {
        if (this.collationTable == null) {
            this.collationTable = new HashMap();
        }
        this.collationTable.put(string, comparator);
        if (bl) {
            this.defaultCollationName = string;
        }
    }

    protected Comparator findCollation(String string) {
        Comparator comparator = null;
        if (string == null) {
            string = this.defaultCollationName;
        }
        if (this.collationTable != null) {
            comparator = (Comparator)this.collationTable.get(string);
        }
        if (comparator != null) {
            return comparator;
        }
        XSLStyleSheet xSLStyleSheet = this.getPrincipalStyleSheet();
        List list = xSLStyleSheet.getTopLevel();
        int n = list.size() - 1;
        while (n >= 0) {
            if (list.get(n) instanceof SAXONCollation) {
                SAXONCollation sAXONCollation = (SAXONCollation)list.get(n);
                if (string == null && sAXONCollation.isDefaultCollation()) {
                    this.defaultCollationName = sAXONCollation.getCollationName();
                    return sAXONCollation.getCollator();
                }
                if (sAXONCollation.getCollationName().equals(string)) {
                    return sAXONCollation.getCollator();
                }
            }
            --n;
        }
        if (string == null) {
            return null;
        }
        try {
            return CollationFactory.makeCollationFromURI(string);
        }
        catch (TransformerException transformerException) {
            return null;
        }
    }

    public String getDefaultCollationName() {
        if (this.defaultCollationName != null) {
            return this.defaultCollationName;
        }
        this.findCollation(null);
        if (this.defaultCollationName != null) {
            return this.defaultCollationName;
        }
        return CodepointCollator.URI;
    }

    public void setSortSpecification(String string, String string2, SortKeyDefinition[] sortKeyDefinitionArray) {
        if (this.sortKeyTable == null) {
            this.sortKeyTable = new HashMap();
        }
        this.sortKeyTable.put(string2 + "#" + string, sortKeyDefinitionArray);
    }

    public XSLCharacterMap getCharacterMap(int n) {
        int n2 = this.topLevel.size() - 1;
        while (n2 >= 0) {
            XSLCharacterMap xSLCharacterMap;
            if (this.topLevel.get(n2) instanceof XSLCharacterMap && (xSLCharacterMap = (XSLCharacterMap)this.topLevel.get(n2)).getCharacterMapFingerprint() == n) {
                return xSLCharacterMap;
            }
            --n2;
        }
        return null;
    }

    public void setPrecedence(int n) {
        this.precedence = n;
    }

    public int getPrecedence() {
        if (this.wasIncluded) {
            return this.importer.getPrecedence();
        }
        return this.precedence;
    }

    public int getMinImportPrecedence() {
        return this.minImportPrecedence;
    }

    public void setMinImportPrecedence(int n) {
        this.minImportPrecedence = n;
    }

    public void setImporter(XSLStyleSheet xSLStyleSheet) {
        this.importer = xSLStyleSheet;
    }

    public XSLStyleSheet getImporter() {
        return this.importer;
    }

    public void setWasIncluded() {
        this.wasIncluded = true;
    }

    public List getTopLevel() {
        return this.topLevel;
    }

    public int allocateSlotNumber() {
        return this.numberOfVariables++;
    }

    public void allocateLocalSlots(int n) {
        if (n > this.largestStackFrame) {
            this.largestStackFrame = n;
        }
    }

    public void prepareAttributes() throws TransformerConfigurationException {
        StandardNames standardNames = this.getStandardNames();
        AttributeCollection attributeCollection = this.getAttributeList();
        int n = 0;
        while (n < attributeCollection.getLength()) {
            int n2 = attributeCollection.getNameCode(n);
            int n3 = n2 & 0xFFFFF;
            if (n3 == standardNames.VERSION) {
                this.processVersionAttribute(n3);
            } else if (n3 != standardNames.ID && n3 != standardNames.EXTENSION_ELEMENT_PREFIXES && n3 != standardNames.EXCLUDE_RESULT_PREFIXES) {
                this.checkUnknownAttribute(n2);
            }
            ++n;
        }
        if (this.version == null) {
            this.reportAbsence("version");
        }
    }

    protected int getNamespaceAlias(short s) {
        int n = 0;
        while (n < this.numberOfAliases) {
            if (s == this.aliasSCodes[n]) {
                return this.aliasNCodes[n];
            }
            ++n;
        }
        return s;
    }

    public void validate() throws TransformerConfigurationException {
        if (this.validationError != null) {
            this.compileError(this.validationError);
        }
        if (!(this.getParentNode() instanceof DocumentInfo)) {
            throw new TransformerConfigurationException(this.getDisplayName() + " must be the outermost element");
        }
    }

    public void preprocess() throws TransformerConfigurationException {
        this.spliceIncludes();
        this.buildIndexes();
        this.processAllAttributes();
        this.collectNamespaceAliases();
        int n = 0;
        while (n < this.topLevel.size()) {
            Object e = this.topLevel.get(n);
            if (e instanceof StyleElement) {
                ((StyleElement)e).fixupReferences();
            }
            ++n;
        }
        this.validate();
        int n2 = 0;
        while (n2 < this.topLevel.size()) {
            Object e = this.topLevel.get(n2);
            if (e instanceof StyleElement) {
                ((StyleElement)e).validateSubtree();
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.topLevel.size()) {
            Object e = this.topLevel.get(n3);
            if (e instanceof StyleElement) {
                try {
                    ((StyleElement)e).preprocess();
                }
                catch (TransformerConfigurationException transformerConfigurationException) {
                    ((StyleElement)e).compileError(transformerConfigurationException);
                }
            }
            ++n3;
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void spliceIncludes() throws TransformerConfigurationException {
        var1_1 = false;
        this.topLevel = new ArrayList<E>();
        this.minImportPrecedence = this.precedence;
        var2_2 /* !! */  = this;
        var3_3 = this.iterateAxis((byte)3);
        while (var3_3.hasNext()) {
            block10: {
                var4_4 = (NodeInfo)var3_3.next();
                if (var4_4.getItemType() == 3) {
                    if (Navigator.isWhite(var4_4.getStringValue())) continue;
                    var2_2 /* !! */ .compileError("No character data is allowed between top-level elements");
                    continue;
                }
                if (var4_4 instanceof DataElement) continue;
                var2_2 /* !! */  = (StyleElement)var4_4;
                if (!(var4_4 instanceof XSLGeneralIncorporate)) break block10;
                var5_5 = (XSLGeneralIncorporate)var4_4;
                var5_5.processAttributes();
                if (var5_5.isImport()) {
                    if (var1_1) {
                        var5_5.compileError("xsl:import elements must come first");
                    }
                } else {
                    var1_1 = true;
                }
                if ((var6_6 = var5_5.getIncludedStyleSheet(this, this.precedence)) == null) {
                    return;
                }
                if (var5_5.isImport()) {
                    this.precedence = var6_6.getPrecedence() + 1;
                } else {
                    this.precedence = var6_6.getPrecedence();
                    var6_6.setMinImportPrecedence(this.minImportPrecedence);
                    var6_6.setWasIncluded();
                }
                var7_7 = var6_6.topLevel;
                var8_8 = 0;
                while (var8_8 < var7_7.size()) {
                    block11: {
                        var9_9 = (StyleElement)var7_7.get(var8_8);
                        var10_10 = this.topLevel.size() - 1;
                        if (var10_10 >= 0 && var9_9.getPrecedence() < ((StyleElement)this.topLevel.get(var10_10)).getPrecedence()) ** GOTO lbl40
                        this.topLevel.add(var9_9);
                        break block11;
lbl-1000:
                        // 1 sources

                        {
                            --var10_10;
lbl40:
                            // 2 sources

                            ** while (var10_10 >= 0 && var9_9.getPrecedence() < ((StyleElement)this.topLevel.get((int)var10_10)).getPrecedence())
                        }
lbl41:
                        // 1 sources

                        this.topLevel.add(var10_10 + 1, var9_9);
                    }
                    ++var8_8;
                }
                continue;
            }
            var1_1 = true;
            this.topLevel.add(var4_4);
        }
    }

    private void buildIndexes() throws TransformerConfigurationException {
        int n = this.topLevel.size() - 1;
        while (n >= 0) {
            Object e = this.topLevel.get(n);
            if (e instanceof XSLVariableDeclaration) {
                XSLVariableDeclaration xSLVariableDeclaration = (XSLVariableDeclaration)e;
                int n2 = xSLVariableDeclaration.getVariableFingerprint();
                if (n2 != -1) {
                    Integer n3 = new Integer(n2);
                    XSLVariableDeclaration xSLVariableDeclaration2 = (XSLVariableDeclaration)this.variableMap.get(n3);
                    if (xSLVariableDeclaration2 == null) {
                        this.variableMap.put(n3, xSLVariableDeclaration);
                    } else {
                        int n4;
                        int n5 = xSLVariableDeclaration.getPrecedence();
                        if (n5 == (n4 = xSLVariableDeclaration2.getPrecedence())) {
                            xSLVariableDeclaration.compileError("Duplicate global variable declaration (see line " + xSLVariableDeclaration2.getLineNumber() + " of " + xSLVariableDeclaration2.getSystemId() + ")");
                        } else if (n5 < n4) {
                            xSLVariableDeclaration.setRedundant();
                        } else {
                            xSLVariableDeclaration2.setRedundant();
                            this.variableMap.put(n3, xSLVariableDeclaration);
                        }
                    }
                }
            } else if (e instanceof XSLNamespaceAlias) {
                this.namespaceAliasList.add(e);
                ++this.numberOfAliases;
            }
            --n;
        }
    }

    private void collectNamespaceAliases() throws TransformerConfigurationException {
        this.aliasSCodes = new short[this.numberOfAliases];
        this.aliasNCodes = new int[this.numberOfAliases];
        int n = 0;
        int n2 = -1;
        int n3 = 0;
        while (n3 < this.numberOfAliases) {
            XSLNamespaceAlias xSLNamespaceAlias = (XSLNamespaceAlias)this.namespaceAliasList.get(n3);
            short s = xSLNamespaceAlias.getStylesheetURICode();
            int n4 = xSLNamespaceAlias.getResultNamespaceCode();
            int n5 = xSLNamespaceAlias.getPrecedence();
            if (n2 != n5) {
                n2 = n5;
                n = n3;
            }
            int n6 = n;
            while (n6 < n3) {
                if (s == this.aliasSCodes[n6] && (n4 & 0xFFFF) != (this.aliasNCodes[n6] & 0xFFFF)) {
                    xSLNamespaceAlias.compileError("Inconsistent namespace aliases");
                }
                ++n6;
            }
            this.aliasSCodes[n3] = s;
            this.aliasNCodes[n3] = n4;
            ++n3;
        }
        this.namespaceAliasList = null;
    }

    protected boolean hasNamespaceAliases() {
        return this.numberOfAliases > 0;
    }

    public void processAllAttributes() throws TransformerConfigurationException {
        this.prepareAttributes();
        int n = 0;
        while (n < this.topLevel.size()) {
            Object e = this.topLevel.get(n);
            if (e instanceof StyleElement) {
                try {
                    ((StyleElement)e).processAllAttributes();
                }
                catch (TransformerConfigurationException transformerConfigurationException) {
                    ((StyleElement)e).compileError(transformerConfigurationException);
                }
            }
            ++n;
        }
    }

    public XSLVariableDeclaration getGlobalVariable(int n) {
        return (XSLVariableDeclaration)this.variableMap.get(new Integer(n));
    }

    public Properties gatherOutputProperties(int n) throws TransformerConfigurationException {
        boolean bl = n == -1;
        Properties properties = new Properties();
        int n2 = 0;
        while (n2 < this.topLevel.size()) {
            XSLOutput xSLOutput;
            Object e = this.topLevel.get(n2);
            if (e instanceof XSLOutput && (xSLOutput = (XSLOutput)e).getOutputFingerprint() == n) {
                bl = true;
                xSLOutput.gatherOutputProperties(properties);
            }
            ++n2;
        }
        if (!bl) {
            throw new TransformerConfigurationException("Requested output format has not been defined");
        }
        return properties;
    }

    public Class getExternalJavaClass(String string) {
        if (!this.getPreparedStyleSheet().getConfiguration().isAllowExternalFunctions()) {
            return null;
        }
        int n = this.topLevel.size() - 1;
        while (n >= 0) {
            SAXONScript sAXONScript;
            Class clazz;
            Object e = this.topLevel.get(n);
            if (e instanceof SAXONScript && (clazz = (sAXONScript = (SAXONScript)e).getJavaClass(string)) != null) {
                return clazz;
            }
            --n;
        }
        return null;
    }

    public Instruction compile() throws TransformerConfigurationException {
        Executable executable = new Executable();
        try {
            StyleElement styleElement;
            Object object;
            Object object2;
            int n = 0;
            while (n < this.topLevel.size()) {
                object2 = (NodeInfo)this.topLevel.get(n);
                if (object2 instanceof StyleElement && (object = (styleElement = (StyleElement)object2).compile()) != null) {
                    ((Instruction)object).setSourceLocation(this.putModuleNumber(styleElement.getSystemId()), styleElement.getLineNumber());
                }
                ++n;
            }
            if (this.decimalFormatManager != null) {
                this.decimalFormatManager.fixupDefaultDefault();
            }
            executable.setModuleArray(this.getModuleArray());
            executable.setRuleManager(this.ruleManager);
            executable.setKeyManager(this.keyManager);
            executable.setStripperRules(this.stripperRules);
            executable.setStripsWhitespace(this.stripsWhitespace());
            executable.setDecimalFormatManager(this.decimalFormatManager);
            executable.setSortKeyTable(this.sortKeyTable);
            executable.setDefaultCollationName(this.defaultCollationName);
            executable.setCollationTable(this.collationTable);
            executable.setDefaultOutputProperties(this.gatherOutputProperties(-1));
            executable.setSlotSpace(this.numberOfVariables, this.largestStackFrame);
            if (this.runtimeTemplateMapRequired) {
                object2 = new HashMap();
                int n2 = 0;
                while (n2 < this.topLevel.size()) {
                    int n3;
                    if (this.topLevel.get(n2) instanceof XSLTemplate && (n3 = ((XSLTemplate)(object = (XSLTemplate)this.topLevel.get(n2))).getTemplateFingerprint()) != -1) {
                        ((HashMap)object2).put(new Integer(n3), ((XSLTemplate)object).getCompiledTemplate());
                    }
                    ++n2;
                }
                executable.setNamedTemplateTable((HashMap)object2);
            }
            int n4 = 0;
            while (n4 < this.topLevel.size()) {
                if (this.topLevel.get(n4) instanceof XSLCharacterMap && !((XSLCharacterMap)(styleElement = (XSLCharacterMap)this.topLevel.get(n4))).isRedundant()) {
                    int n5 = ((XSLCharacterMap)styleElement).getCharacterMapFingerprint();
                    HashMap hashMap = new HashMap();
                    ((XSLCharacterMap)styleElement).assemble(hashMap);
                    if (this.characterMapIndex == null) {
                        this.characterMapIndex = new HashMap();
                    }
                    this.characterMapIndex.put(new Integer(n5), hashMap);
                }
                ++n4;
            }
            executable.setCharacterMapIndex(this.characterMapIndex);
            return executable;
        }
        catch (RuntimeException runtimeException) {
            if (this.getPreparedStyleSheet().getErrorCount() > 0) {
                return executable;
            }
            throw runtimeException;
        }
    }
}

