/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.Properties;
import javax.xml.transform.TransformerConfigurationException;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.ResultDocument;
import net.sf.saxon.om.NamespaceException;
import net.sf.saxon.om.Validation;
import net.sf.saxon.style.StandardNames;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.tree.AttributeCollection;
import net.sf.saxon.xpath.XPathException;

public class XSLResultDocument
extends StyleElement {
    private Expression href;
    private int format = -1;
    private String typeInformation = null;

    public boolean isInstruction() {
        return true;
    }

    public boolean mayContainTemplateBody() {
        return true;
    }

    public void prepareAttributes() throws TransformerConfigurationException {
        int n;
        StandardNames standardNames = this.getStandardNames();
        AttributeCollection attributeCollection = this.getAttributeList();
        String string = null;
        String string2 = null;
        String string3 = null;
        int n2 = 0;
        while (n2 < attributeCollection.getLength()) {
            n = attributeCollection.getNameCode(n2);
            int n3 = n & 0xFFFFF;
            if (n3 == standardNames.FORMAT) {
                string = attributeCollection.getValue(n2).trim();
            } else if (n3 == standardNames.HREF) {
                string2 = attributeCollection.getValue(n2).trim();
            } else if (n3 == standardNames.VALIDATION) {
                string3 = attributeCollection.getValue(n2).trim();
            } else {
                this.checkUnknownAttribute(n);
            }
            ++n2;
        }
        if (string2 == null) {
            this.reportAbsence("href");
        } else {
            this.href = this.makeAttributeValueTemplate(string2);
        }
        if (string != null) {
            try {
                this.format = this.makeNameCode(string, false) & 0xFFFFF;
            }
            catch (NamespaceException namespaceException) {
                this.compileError(namespaceException.getMessage());
            }
            catch (XPathException xPathException) {
                this.compileError(xPathException.getMessage());
            }
        }
        if (string3 == null) {
            this.typeInformation = "none";
        } else {
            n = Validation.getCode(string3);
            if (n == 1) {
                this.compileError("validation=strict is not yet supported");
            }
            if (n == 2) {
                this.compileError("validation=lax is not yet supported");
            }
            if (n == 3) {
                this.typeInformation = "preserve";
            }
            if (n == 4) {
                this.typeInformation = "none";
            }
            if (n == -1) {
                this.compileError("invalid value of validation attribute");
            }
        }
    }

    public void validate() throws TransformerConfigurationException {
        this.checkWithinTemplate();
        if (!this.getPreparedStyleSheet().getConfiguration().isAllowExternalFunctions()) {
            this.compileError("xsl:result-document is disabled when extension functions are disabled");
        }
        this.href = this.typeCheck("href", this.href);
    }

    public Instruction compile() throws TransformerConfigurationException {
        Properties properties = null;
        try {
            properties = this.getPrincipalStyleSheet().gatherOutputProperties(this.format);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            this.compileError("Named output format has not been defined");
            return null;
        }
        if (!this.typeInformation.equals("preserve")) {
            properties.setProperty("{http://saxon.sf.net/}type-information", this.typeInformation);
        }
        ResultDocument resultDocument = new ResultDocument(properties, this.href, this.getBaseURI());
        this.compileChildren(resultDocument);
        return resultDocument;
    }
}

