/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import javax.xml.transform.TransformerConfigurationException;
import net.sf.saxon.Loader;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.Number;
import net.sf.saxon.number.NumberFormatter;
import net.sf.saxon.number.Numberer;
import net.sf.saxon.number.Numberer_en;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.style.StandardNames;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.tree.AttributeCollection;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.xpath.XPathException;

public class XSLNumber
extends StyleElement {
    private static final int SINGLE = 0;
    private static final int MULTI = 1;
    private static final int ANY = 2;
    private static final int SIMPLE = 3;
    private int level;
    private Pattern count = null;
    private Pattern from = null;
    private Expression select = null;
    private Expression value = null;
    private Expression format = null;
    private Expression groupSize = null;
    private Expression groupSeparator = null;
    private Expression letterValue = null;
    private Expression lang = null;
    private NumberFormatter formatter = null;
    private Numberer numberer = null;
    private boolean hasVariablesInPatterns = false;
    private static Numberer defaultNumberer = new Numberer_en();

    public boolean isInstruction() {
        return true;
    }

    protected int getReturnedItemType() {
        return 3;
    }

    public void prepareAttributes() throws TransformerConfigurationException {
        StandardNames standardNames = this.getStandardNames();
        AttributeCollection attributeCollection = this.getAttributeList();
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        String string10 = null;
        int n = 0;
        while (n < attributeCollection.getLength()) {
            int n2 = attributeCollection.getNameCode(n);
            int n3 = n2 & 0xFFFFF;
            if (n3 == standardNames.SELECT) {
                string = attributeCollection.getValue(n);
            } else if (n3 == standardNames.VALUE) {
                string2 = attributeCollection.getValue(n);
            } else if (n3 == standardNames.COUNT) {
                string3 = attributeCollection.getValue(n);
            } else if (n3 == standardNames.FROM) {
                string4 = attributeCollection.getValue(n);
            } else if (n3 == standardNames.LEVEL) {
                string5 = attributeCollection.getValue(n).trim();
            } else if (n3 == standardNames.FORMAT) {
                string6 = attributeCollection.getValue(n);
            } else if (n3 == standardNames.LANG) {
                string9 = attributeCollection.getValue(n);
            } else if (n3 == standardNames.LETTER_VALUE) {
                string10 = attributeCollection.getValue(n).trim();
            } else if (n3 == standardNames.GROUPING_SIZE) {
                string7 = attributeCollection.getValue(n).trim();
            } else if (n3 == standardNames.GROUPING_SEPARATOR) {
                string8 = attributeCollection.getValue(n);
            } else {
                this.checkUnknownAttribute(n2);
            }
            ++n;
        }
        if (string != null) {
            this.select = this.makeExpression(string);
        }
        if (string2 != null) {
            this.value = this.makeExpression(string2);
            if (string != null) {
                this.compileError("The select attribute and value attribute must not both be present");
            }
            if (string3 != null) {
                this.compileError("The count attribute and value attribute must not both be present");
            }
            if (string4 != null) {
                this.compileError("The from attribute and value attribute must not both be present");
            }
            if (string5 != null) {
                this.compileError("The level attribute and value attribute must not both be present");
            }
        }
        if (string3 != null) {
            this.count = this.makePattern(string3);
            if (string3.indexOf(36) >= 0) {
                this.hasVariablesInPatterns = true;
            }
        } else {
            Pattern pattern = this.getContextNodePattern();
            if (pattern instanceof NameTest) {
                this.count = pattern;
            }
        }
        if (string4 != null) {
            this.from = this.makePattern(string4);
            if (string4.indexOf(36) >= 0) {
                this.hasVariablesInPatterns = true;
            }
        }
        if (string5 == null) {
            this.level = 0;
        } else if (string5.equals("single")) {
            this.level = 0;
        } else if (string5.equals("multiple")) {
            this.level = 1;
        } else if (string5.equals("any")) {
            this.level = 2;
        } else {
            this.compileError("Invalid value for level attribute");
        }
        if (this.level == 0 && this.from == null && this.count == null) {
            this.level = 3;
        }
        if (string6 != null) {
            this.format = this.makeAttributeValueTemplate(string6);
            if (this.format instanceof StringValue) {
                this.formatter = new NumberFormatter();
                this.formatter.prepare(((StringValue)this.format).getStringValue());
            }
        } else {
            this.formatter = new NumberFormatter();
            this.formatter.prepare("1");
        }
        if (string8 != null && string7 != null) {
            this.groupSize = this.makeAttributeValueTemplate(string7);
            this.groupSeparator = this.makeAttributeValueTemplate(string8);
        }
        if (string9 == null) {
            this.numberer = defaultNumberer;
        } else {
            this.lang = this.makeAttributeValueTemplate(string9);
            if (this.lang instanceof StringValue) {
                this.numberer = XSLNumber.makeNumberer(((StringValue)this.lang).getStringValue());
            }
        }
        if (string10 != null) {
            this.letterValue = this.makeAttributeValueTemplate(string10);
        }
    }

    public void validate() throws TransformerConfigurationException {
        block2: {
            this.checkWithinTemplate();
            this.checkEmpty();
            this.select = this.typeCheck("select", this.select);
            this.value = this.typeCheck("value", this.value);
            this.format = this.typeCheck("format", this.format);
            this.groupSize = this.typeCheck("group-size", this.groupSize);
            this.groupSeparator = this.typeCheck("group-separator", this.groupSeparator);
            this.letterValue = this.typeCheck("letter-value", this.letterValue);
            this.lang = this.typeCheck("lang", this.lang);
            this.from = this.typeCheck("from", this.from);
            this.count = this.typeCheck("count", this.count);
            if (this.select == null) break block2;
            try {
                RoleLocator roleLocator = new RoleLocator(4, "xsl:number/select", 0);
                this.select = TypeChecker.staticTypeCheck(this.select, SequenceType.SINGLE_NODE, false, roleLocator);
            }
            catch (XPathException xPathException) {
                this.compileError(xPathException);
            }
        }
    }

    public Instruction compile() throws TransformerConfigurationException {
        Number number = new Number(this.select, this.level, this.count, this.from, this.value, this.format, this.groupSize, this.groupSeparator, this.letterValue, this.lang, this.formatter, this.numberer, this.hasVariablesInPatterns);
        return number;
    }

    protected static Numberer makeNumberer(String string) {
        Numberer numberer;
        if (string.equals("en")) {
            numberer = defaultNumberer;
        } else {
            String string2 = "net.sf.saxon.number.Numberer_";
            int n = 0;
            while (n < string.length()) {
                if (Character.isLetter(string.charAt(n))) {
                    string2 = string2 + string.charAt(n);
                }
                ++n;
            }
            try {
                numberer = (Numberer)Loader.getInstance(string2);
            }
            catch (Exception exception) {
                numberer = defaultNumberer;
            }
        }
        return numberer;
    }
}

